/*
 * Decompiled with CFR 0.152.
 */
package japlot;

import japlot.ComplexCellRenderer;
import japlot.DataPanel;
import japlot.Util;
import japlot.jaxodraw.JaxoMainPanel;
import japlot.jaxodraw.JaxoPrefs;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import jhplot.jadraw.JaAxes;
import jplot.DataArray;

public class DataBrowser
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JButton closeButton;
    private JButton okButton;
    private DataPanel mainPanel;
    public JList list;
    public DefaultListModel variableModel;
    private JaxoMainPanel frame;
    private JSplitPane splitPane;
    private boolean isChanged = false;

    public DataBrowser(JaAxes ja, JaxoMainPanel frame) {
        this.frame = frame;
        this.setTitle("Data editor");
        this.setModal(false);
        this.setResizable(true);
        this.setDefaultCloseOperation(2);
        JPanel lowerPanel = new JPanel();
        this.mainPanel = new DataPanel(ja, frame);
        this.closeButton = new JButton();
        this.closeButton.setText("Cancel");
        this.okButton = new JButton();
        this.okButton.setText("Accept");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataBrowser.this.isChanged = false;
                DataBrowser.this.exit(false);
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataBrowser.this.doChanges();
            }
        });
        lowerPanel.add((Component)this.okButton, null);
        lowerPanel.add((Component)this.closeButton, null);
        JScrollPane jCandScroll = new JScrollPane();
        jCandScroll.setPreferredSize(new Dimension(1, 1));
        jCandScroll.setMinimumSize(new Dimension(0, 0));
        Vector<DataArray> data = ja.getData();
        this.list = new JList<DataArray>(data);
        this.list.setSelectionMode(0);
        this.list.setSelectedIndex(0);
        ComplexCellRenderer renderer = new ComplexCellRenderer();
        this.list.setCellRenderer(renderer);
        if (data.size() > 0) {
            Object o = this.list.getModel().getElementAt(0);
            DataArray da = (DataArray)o;
            this.mainPanel.setDataArray(da);
        }
        JScrollPane listScrollPane = new JScrollPane();
        listScrollPane.getViewport().add(this.list);
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int index;
                JList theList = (JList)mouseEvent.getSource();
                if (mouseEvent.getClickCount() == 1 && (index = theList.locationToIndex(mouseEvent.getPoint())) >= 0) {
                    Object o = theList.getModel().getElementAt(index);
                    DataArray da = (DataArray)o;
                    DataBrowser.this.mainPanel.setDataArray(da);
                }
            }
        };
        this.list.addMouseListener(mouseListener);
        this.splitPane = new JSplitPane(1, listScrollPane, this.mainPanel);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerLocation(80);
        this.getContentPane().add((Component)this.splitPane, "Center");
        this.getContentPane().add((Component)lowerPanel, "South");
    }

    public void doChanges() {
        this.mainPanel.setStyle();
        this.isChanged = true;
        this.showIt(false);
        this.frame.update();
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public void exit(boolean show) {
        this.frame.getOptMenu().showBrowserbar(false);
        JaxoPrefs.setBooleanPref(306, false);
    }

    public void showIt(boolean show) {
        if (!show) {
            this.setVisible(false);
            this.dispose();
        } else {
            Dimension dim = this.frame.getSize();
            int w = dim.width;
            int h = dim.height;
            Dimension res = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension size = new Dimension(Math.min((int)(0.4 * (double)w), res.width), Math.min((int)(0.6 * (double)h), res.height));
            this.setSize(size);
            Util.centreWithin(this.frame, this);
            this.setVisible(true);
        }
    }
}

