/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat.quantile;

import cern.colt.PersistentObject;
import cern.colt.function.DoubleProcedure;
import cern.colt.list.DoubleArrayList;
import cern.jet.stat.Descriptive;
import cern.jet.stat.quantile.DoubleQuantileFinder;

class ExactDoubleQuantileFinder
extends PersistentObject
implements DoubleQuantileFinder {
    protected DoubleArrayList buffer = new DoubleArrayList(0);
    protected boolean isSorted;

    public ExactDoubleQuantileFinder() {
        this.clear();
    }

    @Override
    public void add(double d) {
        this.buffer.add(d);
        this.isSorted = false;
    }

    @Override
    public void addAllOf(DoubleArrayList doubleArrayList) {
        this.addAllOfFromTo(doubleArrayList, 0, doubleArrayList.size() - 1);
    }

    @Override
    public void addAllOfFromTo(DoubleArrayList doubleArrayList, int n, int n2) {
        this.buffer.addAllOfFromTo(doubleArrayList, n, n2);
        this.isSorted = false;
    }

    @Override
    public void clear() {
        this.buffer.clear();
        this.buffer.trimToSize();
        this.isSorted = false;
    }

    @Override
    public Object clone() {
        ExactDoubleQuantileFinder exactDoubleQuantileFinder = (ExactDoubleQuantileFinder)super.clone();
        if (this.buffer != null) {
            exactDoubleQuantileFinder.buffer = exactDoubleQuantileFinder.buffer.copy();
        }
        return exactDoubleQuantileFinder;
    }

    public boolean contains(double d) {
        this.sort();
        return this.buffer.binarySearch(d) >= 0;
    }

    @Override
    public boolean forEach(DoubleProcedure doubleProcedure) {
        double[] dArray = this.buffer.elements();
        int n = (int)this.size();
        int n2 = 0;
        while (n2 < n) {
            if (doubleProcedure.apply(dArray[n2++])) continue;
            return false;
        }
        return true;
    }

    @Override
    public long memory() {
        return this.buffer.elements().length;
    }

    @Override
    public double phi(double d) {
        this.sort();
        return Descriptive.rankInterpolated(this.buffer, d) / (double)this.size();
    }

    @Override
    public DoubleArrayList quantileElements(DoubleArrayList doubleArrayList) {
        this.sort();
        return Descriptive.quantiles(this.buffer, doubleArrayList);
    }

    @Override
    public long size() {
        return this.buffer.size();
    }

    protected void sort() {
        if (!this.isSorted) {
            this.buffer.sort();
            this.isSorted = true;
        }
    }

    public String toString() {
        String string = this.getClass().getName();
        string = string.substring(string.lastIndexOf(46) + 1);
        return string + "(mem=" + this.memory() + ", size=" + this.size() + ")";
    }

    @Override
    public long totalMemory() {
        return this.memory();
    }
}

