/*
 * Decompiled with CFR 0.152.
 */
package cern.hep.aida.ref;

import cern.hep.aida.ref.AbstractHistogram3D;
import cern.hep.aida.ref.FixedAxis;
import cern.hep.aida.ref.Histogram2D;
import cern.hep.aida.ref.VariableAxis;
import colt.hep.aida.IAxis;
import colt.hep.aida.IHistogram2D;
import colt.hep.aida.IHistogram3D;

public class Histogram3D
extends AbstractHistogram3D
implements IHistogram3D {
    private double[][][] heights;
    private double[][][] errors;
    private int[][][] entries;
    private int nEntry;
    private double sumWeight;
    private double sumWeightSquared;
    private double meanX;
    private double rmsX;
    private double meanY;
    private double rmsY;
    private double meanZ;
    private double rmsZ;

    public Histogram3D(String string, double[] dArray, double[] dArray2, double[] dArray3) {
        this(string, new VariableAxis(dArray), new VariableAxis(dArray2), new VariableAxis(dArray3));
    }

    public Histogram3D(String string, int n, double d, double d2, int n2, double d3, double d4, int n3, double d5, double d6) {
        this(string, new FixedAxis(n, d, d2), new FixedAxis(n2, d3, d4), new FixedAxis(n3, d5, d6));
    }

    public Histogram3D(String string, IAxis iAxis, IAxis iAxis2, IAxis iAxis3) {
        super(string);
        this.xAxis = iAxis;
        this.yAxis = iAxis2;
        this.zAxis = iAxis3;
        int n = iAxis.bins();
        int n2 = iAxis2.bins();
        int n3 = iAxis3.bins();
        this.entries = new int[n + 2][n2 + 2][n3 + 2];
        this.heights = new double[n + 2][n2 + 2][n3 + 2];
        this.errors = new double[n + 2][n2 + 2][n3 + 2];
    }

    @Override
    public int allEntries() {
        return this.nEntry;
    }

    @Override
    public int binEntries(int n, int n2, int n3) {
        return this.entries[this.mapX(n)][this.mapY(n2)][this.mapZ(n3)];
    }

    @Override
    public double binError(int n, int n2, int n3) {
        return Math.sqrt(this.errors[this.mapX(n)][this.mapY(n2)][this.mapZ(n3)]);
    }

    @Override
    public double binHeight(int n, int n2, int n3) {
        return this.heights[this.mapX(n)][this.mapY(n2)][this.mapZ(n3)];
    }

    @Override
    public double equivalentBinEntries() {
        return this.sumWeight * this.sumWeight / this.sumWeightSquared;
    }

    @Override
    public void fill(double d, double d2, double d3) {
        int n = this.mapX(this.xAxis.coordToIndex(d));
        int n2 = this.mapY(this.yAxis.coordToIndex(d2));
        int n3 = this.mapZ(this.zAxis.coordToIndex(d3));
        int[] nArray = this.entries[n][n2];
        int n4 = n3;
        nArray[n4] = nArray[n4] + 1;
        double[] dArray = this.heights[n][n2];
        int n5 = n3;
        dArray[n5] = dArray[n5] + 1.0;
        double[] dArray2 = this.errors[n][n2];
        int n6 = n3;
        dArray2[n6] = dArray2[n6] + 1.0;
        ++this.nEntry;
        this.sumWeight += 1.0;
        this.sumWeightSquared += 1.0;
        this.meanX += d;
        this.rmsX += d;
        this.meanY += d2;
        this.rmsY += d2;
        this.meanZ += d3;
        this.rmsZ += d3;
    }

    @Override
    public void fill(double d, double d2, double d3, double d4) {
        int n = this.mapX(this.xAxis.coordToIndex(d));
        int n2 = this.mapY(this.yAxis.coordToIndex(d2));
        int n3 = this.mapZ(this.zAxis.coordToIndex(d3));
        int[] nArray = this.entries[n][n2];
        int n4 = n3;
        nArray[n4] = nArray[n4] + 1;
        double[] dArray = this.heights[n][n2];
        int n5 = n3;
        dArray[n5] = dArray[n5] + d4;
        double[] dArray2 = this.errors[n][n2];
        int n6 = n3;
        dArray2[n6] = dArray2[n6] + d4 * d4;
        ++this.nEntry;
        this.sumWeight += d4;
        this.sumWeightSquared += d4 * d4;
        this.meanX += d * d4;
        this.rmsX += d * d4 * d4;
        this.meanY += d2 * d4;
        this.rmsY += d2 * d4 * d4;
        this.meanZ += d3 * d4;
        this.rmsZ += d3 * d4 * d4;
    }

    @Override
    protected IHistogram2D internalSliceXY(String string, int n, int n2) {
        if (n2 < n) {
            throw new IllegalArgumentException("Invalid bin range");
        }
        int n3 = this.xAxis.bins() + 2;
        int n4 = this.yAxis.bins() + 2;
        int[][] nArray = new int[n3][n4];
        double[][] dArray = new double[n3][n4];
        double[][] dArray2 = new double[n3][n4];
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                for (int k = n; k <= n2; ++k) {
                    int[] nArray2 = nArray[i];
                    int n5 = j;
                    nArray2[n5] = nArray2[n5] + this.entries[i][j][k];
                    double[] dArray3 = dArray[i];
                    int n6 = j;
                    dArray3[n6] = dArray3[n6] + this.heights[i][j][k];
                    double[] dArray4 = dArray2[i];
                    int n7 = j;
                    dArray4[n7] = dArray4[n7] + this.errors[i][j][k];
                }
            }
        }
        Histogram2D histogram2D = new Histogram2D(string, this.xAxis, this.yAxis);
        histogram2D.setContents(nArray, dArray, dArray2);
        return histogram2D;
    }

    @Override
    protected IHistogram2D internalSliceXZ(String string, int n, int n2) {
        if (n2 < n) {
            throw new IllegalArgumentException("Invalid bin range");
        }
        int n3 = this.xAxis.bins() + 2;
        int n4 = this.zAxis.bins() + 2;
        int[][] nArray = new int[n3][n4];
        double[][] dArray = new double[n3][n4];
        double[][] dArray2 = new double[n3][n4];
        for (int i = 0; i < n3; ++i) {
            for (int j = n; j <= n2; ++j) {
                int n5 = 0;
                while (i < n4) {
                    int[] nArray2 = nArray[i];
                    int n6 = n5;
                    nArray2[n6] = nArray2[n6] + this.entries[i][j][n5];
                    double[] dArray3 = dArray[i];
                    int n7 = n5;
                    dArray3[n7] = dArray3[n7] + this.heights[i][j][n5];
                    double[] dArray4 = dArray2[i];
                    int n8 = n5;
                    dArray4[n8] = dArray4[n8] + this.errors[i][j][n5];
                    ++n5;
                }
            }
        }
        Histogram2D histogram2D = new Histogram2D(string, this.xAxis, this.zAxis);
        histogram2D.setContents(nArray, dArray, dArray2);
        return histogram2D;
    }

    @Override
    protected IHistogram2D internalSliceYZ(String string, int n, int n2) {
        if (n2 < n) {
            throw new IllegalArgumentException("Invalid bin range");
        }
        int n3 = this.yAxis.bins() + 2;
        int n4 = this.zAxis.bins() + 2;
        int[][] nArray = new int[n3][n4];
        double[][] dArray = new double[n3][n4];
        double[][] dArray2 = new double[n3][n4];
        for (int i = n; i <= n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < n4; ++k) {
                    int[] nArray2 = nArray[j];
                    int n5 = k;
                    nArray2[n5] = nArray2[n5] + this.entries[i][j][k];
                    double[] dArray3 = dArray[j];
                    int n6 = k;
                    dArray3[n6] = dArray3[n6] + this.heights[i][j][k];
                    double[] dArray4 = dArray2[j];
                    int n7 = k;
                    dArray4[n7] = dArray4[n7] + this.errors[i][j][k];
                }
            }
        }
        Histogram2D histogram2D = new Histogram2D(string, this.yAxis, this.zAxis);
        histogram2D.setContents(nArray, dArray, dArray2);
        return histogram2D;
    }

    @Override
    public double meanX() {
        return this.meanX / this.sumWeight;
    }

    @Override
    public double meanY() {
        return this.meanY / this.sumWeight;
    }

    @Override
    public double meanZ() {
        return this.meanZ / this.sumWeight;
    }

    @Override
    public void reset() {
        for (int i = 0; i < this.entries.length; ++i) {
            for (int j = 0; j < this.entries[0].length; ++j) {
                int n = 0;
                while (j < this.entries[0][0].length) {
                    this.entries[i][j][n] = 0;
                    this.heights[i][j][n] = 0.0;
                    this.errors[i][j][n] = 0.0;
                    ++n;
                }
            }
        }
        this.nEntry = 0;
        this.sumWeight = 0.0;
        this.sumWeightSquared = 0.0;
        this.meanX = 0.0;
        this.rmsX = 0.0;
        this.meanY = 0.0;
        this.rmsY = 0.0;
        this.meanZ = 0.0;
        this.rmsZ = 0.0;
    }

    @Override
    public double rmsX() {
        return Math.sqrt(this.rmsX / this.sumWeight - this.meanX * this.meanX / this.sumWeight / this.sumWeight);
    }

    @Override
    public double rmsY() {
        return Math.sqrt(this.rmsY / this.sumWeight - this.meanY * this.meanY / this.sumWeight / this.sumWeight);
    }

    @Override
    public double rmsZ() {
        return Math.sqrt(this.rmsZ / this.sumWeight - this.meanZ * this.meanZ / this.sumWeight / this.sumWeight);
    }

    @Override
    public double sumAllBinHeights() {
        return this.sumWeight;
    }
}

