/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.impl;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;

class WrapperDoubleMatrix1D
extends DoubleMatrix1D {
    protected DoubleMatrix1D content;

    public WrapperDoubleMatrix1D(DoubleMatrix1D doubleMatrix1D) {
        if (doubleMatrix1D != null) {
            this.setUp(doubleMatrix1D.size());
        }
        this.content = doubleMatrix1D;
    }

    @Override
    protected DoubleMatrix1D getContent() {
        return this.content;
    }

    @Override
    public double getQuick(int n) {
        return this.content.getQuick(n);
    }

    @Override
    public DoubleMatrix1D like(int n) {
        return this.content.like(n);
    }

    @Override
    public DoubleMatrix2D like2D(int n, int n2) {
        return this.content.like2D(n, n2);
    }

    @Override
    public void setQuick(int n, double d) {
        this.content.setQuick(n, d);
    }

    @Override
    public DoubleMatrix1D viewFlip() {
        WrapperDoubleMatrix1D wrapperDoubleMatrix1D = new WrapperDoubleMatrix1D(this){

            @Override
            public double getQuick(int n) {
                return this.content.get(this.size - 1 - n);
            }

            @Override
            public void setQuick(int n, double d) {
                this.content.set(this.size - 1 - n, d);
            }
        };
        return wrapperDoubleMatrix1D;
    }

    @Override
    public DoubleMatrix1D viewPart(final int n, int n2) {
        this.checkRange(n, n2);
        WrapperDoubleMatrix1D wrapperDoubleMatrix1D = new WrapperDoubleMatrix1D(this){

            @Override
            public double getQuick(int n2) {
                return this.content.get(n + n2);
            }

            @Override
            public void setQuick(int n2, double d) {
                this.content.set(n + n2, d);
            }
        };
        wrapperDoubleMatrix1D.size = n2;
        return wrapperDoubleMatrix1D;
    }

    @Override
    public DoubleMatrix1D viewSelection(int[] nArray) {
        if (nArray == null) {
            nArray = new int[this.size];
            int n = this.size;
            while (--n >= 0) {
                nArray[n] = n;
            }
        }
        this.checkIndexes(nArray);
        final int[] nArray2 = nArray;
        WrapperDoubleMatrix1D wrapperDoubleMatrix1D = new WrapperDoubleMatrix1D(this){

            @Override
            public double getQuick(int n) {
                return this.content.get(nArray2[n]);
            }

            @Override
            public void setQuick(int n, double d) {
                this.content.set(nArray2[n], d);
            }
        };
        wrapperDoubleMatrix1D.size = nArray.length;
        return wrapperDoubleMatrix1D;
    }

    @Override
    protected DoubleMatrix1D viewSelectionLike(int[] nArray) {
        throw new InternalError();
    }

    @Override
    public DoubleMatrix1D viewStrides(final int n) {
        if (this.stride <= 0) {
            throw new IndexOutOfBoundsException("illegal stride: " + this.stride);
        }
        WrapperDoubleMatrix1D wrapperDoubleMatrix1D = new WrapperDoubleMatrix1D(this){

            @Override
            public double getQuick(int n2) {
                return this.content.get(n2 * n);
            }

            @Override
            public void setQuick(int n2, double d) {
                this.content.set(n2 * n, d);
            }
        };
        wrapperDoubleMatrix1D.size = this.size;
        if (this.size != 0) {
            wrapperDoubleMatrix1D.size = (this.size - 1) / n + 1;
        }
        return wrapperDoubleMatrix1D;
    }
}

