/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.impl;

import cern.colt.map.AbstractIntObjectMap;
import cern.colt.matrix.ObjectMatrix1D;
import cern.colt.matrix.ObjectMatrix2D;
import cern.colt.matrix.impl.SparseObjectMatrix1D;
import cern.colt.matrix.impl.SparseObjectMatrix2D;

class SelectedSparseObjectMatrix1D
extends ObjectMatrix1D {
    protected AbstractIntObjectMap elements;
    protected int[] offsets;
    protected int offset;

    protected SelectedSparseObjectMatrix1D(int n, AbstractIntObjectMap abstractIntObjectMap, int n2, int n3, int[] nArray, int n4) {
        this.setUp(n, n2, n3);
        this.elements = abstractIntObjectMap;
        this.offsets = nArray;
        this.offset = n4;
        this.isNoView = false;
    }

    protected SelectedSparseObjectMatrix1D(AbstractIntObjectMap abstractIntObjectMap, int[] nArray) {
        this(nArray.length, abstractIntObjectMap, 0, 1, nArray, 0);
    }

    @Override
    protected int _offset(int n) {
        return this.offsets[n];
    }

    @Override
    public Object getQuick(int n) {
        return this.elements.get(this.offset + this.offsets[this.zero + n * this.stride]);
    }

    @Override
    protected boolean haveSharedCellsRaw(ObjectMatrix1D objectMatrix1D) {
        if (objectMatrix1D instanceof SelectedSparseObjectMatrix1D) {
            SelectedSparseObjectMatrix1D selectedSparseObjectMatrix1D = (SelectedSparseObjectMatrix1D)objectMatrix1D;
            return this.elements == selectedSparseObjectMatrix1D.elements;
        }
        if (objectMatrix1D instanceof SparseObjectMatrix1D) {
            SparseObjectMatrix1D sparseObjectMatrix1D = (SparseObjectMatrix1D)objectMatrix1D;
            return this.elements == sparseObjectMatrix1D.elements;
        }
        return false;
    }

    @Override
    protected int index(int n) {
        return this.offset + this.offsets[this.zero + n * this.stride];
    }

    @Override
    public ObjectMatrix1D like(int n) {
        return new SparseObjectMatrix1D(n);
    }

    @Override
    public ObjectMatrix2D like2D(int n, int n2) {
        return new SparseObjectMatrix2D(n, n2);
    }

    @Override
    public void setQuick(int n, Object object) {
        int n2 = this.offset + this.offsets[this.zero + n * this.stride];
        if (object == null) {
            this.elements.removeKey(n2);
        } else {
            this.elements.put(n2, object);
        }
    }

    @Override
    protected void setUp(int n) {
        super.setUp(n);
        this.stride = 1;
        this.offset = 0;
    }

    @Override
    protected ObjectMatrix1D viewSelectionLike(int[] nArray) {
        return new SelectedSparseObjectMatrix1D(this.elements, nArray);
    }
}

