/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.impl;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;

class SelectedDenseDoubleMatrix1D
extends DoubleMatrix1D {
    protected double[] elements;
    protected int[] offsets;
    protected int offset;

    protected SelectedDenseDoubleMatrix1D(double[] dArray, int[] nArray) {
        this(nArray.length, dArray, 0, 1, nArray, 0);
    }

    protected SelectedDenseDoubleMatrix1D(int n, double[] dArray, int n2, int n3, int[] nArray, int n4) {
        this.setUp(n, n2, n3);
        this.elements = dArray;
        this.offsets = nArray;
        this.offset = n4;
        this.isNoView = false;
    }

    @Override
    protected int _offset(int n) {
        return this.offsets[n];
    }

    @Override
    public double getQuick(int n) {
        return this.elements[this.offset + this.offsets[this.zero + n * this.stride]];
    }

    @Override
    protected boolean haveSharedCellsRaw(DoubleMatrix1D doubleMatrix1D) {
        if (doubleMatrix1D instanceof SelectedDenseDoubleMatrix1D) {
            SelectedDenseDoubleMatrix1D selectedDenseDoubleMatrix1D = (SelectedDenseDoubleMatrix1D)doubleMatrix1D;
            return this.elements == selectedDenseDoubleMatrix1D.elements;
        }
        if (doubleMatrix1D instanceof DenseDoubleMatrix1D) {
            DenseDoubleMatrix1D denseDoubleMatrix1D = (DenseDoubleMatrix1D)doubleMatrix1D;
            return this.elements == denseDoubleMatrix1D.elements;
        }
        return false;
    }

    @Override
    protected int index(int n) {
        return this.offset + this.offsets[this.zero + n * this.stride];
    }

    @Override
    public DoubleMatrix1D like(int n) {
        return new DenseDoubleMatrix1D(n);
    }

    @Override
    public DoubleMatrix2D like2D(int n, int n2) {
        return new DenseDoubleMatrix2D(n, n2);
    }

    @Override
    public void setQuick(int n, double d) {
        this.elements[this.offset + this.offsets[this.zero + n * this.stride]] = d;
    }

    @Override
    protected void setUp(int n) {
        super.setUp(n);
        this.stride = 1;
        this.offset = 0;
    }

    @Override
    protected DoubleMatrix1D viewSelectionLike(int[] nArray) {
        return new SelectedDenseDoubleMatrix1D(this.elements, nArray);
    }
}

