/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.map;

import cern.colt.function.IntIntProcedure;
import cern.colt.function.IntProcedure;
import cern.colt.list.ByteArrayList;
import cern.colt.list.IntArrayList;
import cern.colt.map.AbstractIntIntMap;
import cern.colt.map.HashFunctions;

public class OpenIntIntHashMap
extends AbstractIntIntMap {
    protected int[] table;
    protected int[] values;
    protected byte[] state;
    protected int freeEntries;
    protected static final byte FREE = 0;
    protected static final byte FULL = 1;
    protected static final byte REMOVED = 2;

    public OpenIntIntHashMap() {
        this(277);
    }

    public OpenIntIntHashMap(int n) {
        this(n, 0.2, 0.5);
    }

    public OpenIntIntHashMap(int n, double d, double d2) {
        this.setUp(n, d, d2);
    }

    @Override
    public void clear() {
        new ByteArrayList(this.state).fillFromToWith(0, this.state.length - 1, (byte)0);
        this.distinct = 0;
        this.freeEntries = this.table.length;
        this.trimToSize();
    }

    @Override
    public Object clone() {
        OpenIntIntHashMap openIntIntHashMap = (OpenIntIntHashMap)super.clone();
        openIntIntHashMap.table = (int[])openIntIntHashMap.table.clone();
        openIntIntHashMap.values = (int[])openIntIntHashMap.values.clone();
        openIntIntHashMap.state = (byte[])openIntIntHashMap.state.clone();
        return openIntIntHashMap;
    }

    @Override
    public boolean containsKey(int n) {
        return this.indexOfKey(n) >= 0;
    }

    @Override
    public boolean containsValue(int n) {
        return this.indexOfValue(n) >= 0;
    }

    @Override
    public void ensureCapacity(int n) {
        if (this.table.length < n) {
            int n2 = this.nextPrime(n);
            this.rehash(n2);
        }
    }

    @Override
    public boolean forEachKey(IntProcedure intProcedure) {
        int n = this.table.length;
        while (n-- > 0) {
            if (this.state[n] != 1 || intProcedure.apply(this.table[n])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean forEachPair(IntIntProcedure intIntProcedure) {
        int n = this.table.length;
        while (n-- > 0) {
            if (this.state[n] != 1 || intIntProcedure.apply(this.table[n], this.values[n])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int get(int n) {
        int n2 = this.indexOfKey(n);
        if (n2 < 0) {
            return 0;
        }
        return this.values[n2];
    }

    protected int indexOfInsertion(int n) {
        int[] nArray = this.table;
        byte[] byArray = this.state;
        int n2 = nArray.length;
        int n3 = HashFunctions.hash(n) & Integer.MAX_VALUE;
        int n4 = n3 % n2;
        int n5 = n3 % (n2 - 2);
        if (n5 == 0) {
            n5 = 1;
        }
        while (byArray[n4] == 1 && nArray[n4] != n) {
            if ((n4 -= n5) >= 0) continue;
            n4 += n2;
        }
        if (byArray[n4] == 2) {
            int n6 = n4;
            while (byArray[n4] != 0 && (byArray[n4] == 2 || nArray[n4] != n)) {
                if ((n4 -= n5) >= 0) continue;
                n4 += n2;
            }
            if (byArray[n4] == 0) {
                n4 = n6;
            }
        }
        if (byArray[n4] == 1) {
            return -n4 - 1;
        }
        return n4;
    }

    protected int indexOfKey(int n) {
        int[] nArray = this.table;
        byte[] byArray = this.state;
        int n2 = nArray.length;
        int n3 = HashFunctions.hash(n) & Integer.MAX_VALUE;
        int n4 = n3 % n2;
        int n5 = n3 % (n2 - 2);
        if (n5 == 0) {
            n5 = 1;
        }
        while (byArray[n4] != 0 && (byArray[n4] == 2 || nArray[n4] != n)) {
            if ((n4 -= n5) >= 0) continue;
            n4 += n2;
        }
        if (byArray[n4] == 0) {
            return -1;
        }
        return n4;
    }

    protected int indexOfValue(int n) {
        int[] nArray = this.values;
        byte[] byArray = this.state;
        int n2 = byArray.length;
        while (--n2 >= 0) {
            if (byArray[n2] != 1 || nArray[n2] != n) continue;
            return n2;
        }
        return -1;
    }

    @Override
    public int keyOf(int n) {
        int n2 = this.indexOfValue(n);
        if (n2 < 0) {
            return Integer.MIN_VALUE;
        }
        return this.table[n2];
    }

    @Override
    public void keys(IntArrayList intArrayList) {
        intArrayList.setSize(this.distinct);
        int[] nArray = intArrayList.elements();
        int[] nArray2 = this.table;
        byte[] byArray = this.state;
        int n = 0;
        int n2 = nArray2.length;
        while (n2-- > 0) {
            if (byArray[n2] != 1) continue;
            nArray[n++] = nArray2[n2];
        }
    }

    @Override
    public void pairsMatching(IntIntProcedure intIntProcedure, IntArrayList intArrayList, IntArrayList intArrayList2) {
        intArrayList.clear();
        intArrayList2.clear();
        int n = this.table.length;
        while (n-- > 0) {
            if (this.state[n] != 1 || !intIntProcedure.apply(this.table[n], this.values[n])) continue;
            intArrayList.add(this.table[n]);
            intArrayList2.add(this.values[n]);
        }
    }

    @Override
    public boolean put(int n, int n2) {
        int n3 = this.indexOfInsertion(n);
        if (n3 < 0) {
            n3 = -n3 - 1;
            this.values[n3] = n2;
            return false;
        }
        if (this.distinct > this.highWaterMark) {
            int n4 = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(n4);
            return this.put(n, n2);
        }
        this.table[n3] = n;
        this.values[n3] = n2;
        if (this.state[n3] == 0) {
            --this.freeEntries;
        }
        this.state[n3] = 1;
        ++this.distinct;
        if (this.freeEntries < 1) {
            int n5 = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(n5);
        }
        return true;
    }

    protected void rehash(int n) {
        int n2 = this.table.length;
        int[] nArray = this.table;
        int[] nArray2 = this.values;
        byte[] byArray = this.state;
        int[] nArray3 = new int[n];
        int[] nArray4 = new int[n];
        byte[] byArray2 = new byte[n];
        this.lowWaterMark = this.chooseLowWaterMark(n, this.minLoadFactor);
        this.highWaterMark = this.chooseHighWaterMark(n, this.maxLoadFactor);
        this.table = nArray3;
        this.values = nArray4;
        this.state = byArray2;
        this.freeEntries = n - this.distinct;
        int n3 = n2;
        while (n3-- > 0) {
            if (byArray[n3] != 1) continue;
            int n4 = nArray[n3];
            int n5 = this.indexOfInsertion(n4);
            nArray3[n5] = n4;
            nArray4[n5] = nArray2[n3];
            byArray2[n5] = 1;
        }
    }

    @Override
    public boolean removeKey(int n) {
        int n2 = this.indexOfKey(n);
        if (n2 < 0) {
            return false;
        }
        this.state[n2] = 2;
        --this.distinct;
        if (this.distinct < this.lowWaterMark) {
            int n3 = this.chooseShrinkCapacity(this.distinct, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(n3);
        }
        return true;
    }

    @Override
    protected void setUp(int n, double d, double d2) {
        int n2 = n;
        super.setUp(n2, d, d2);
        n2 = this.nextPrime(n2);
        if (n2 == 0) {
            n2 = 1;
        }
        this.table = new int[n2];
        this.values = new int[n2];
        this.state = new byte[n2];
        this.minLoadFactor = d;
        this.maxLoadFactor = n2 == Integer.MAX_VALUE ? 1.0 : d2;
        this.distinct = 0;
        this.freeEntries = n2;
        this.lowWaterMark = 0;
        this.highWaterMark = this.chooseHighWaterMark(n2, this.maxLoadFactor);
    }

    @Override
    public void trimToSize() {
        int n = this.nextPrime((int)(1.0 + 1.2 * (double)this.size()));
        if (this.table.length > n) {
            this.rehash(n);
        }
    }

    @Override
    public void values(IntArrayList intArrayList) {
        intArrayList.setSize(this.distinct);
        int[] nArray = intArrayList.elements();
        int[] nArray2 = this.values;
        byte[] byArray = this.state;
        int n = 0;
        int n2 = byArray.length;
        while (n2-- > 0) {
            if (byArray[n2] != 1) continue;
            nArray[n++] = nArray2[n2];
        }
    }
}

