/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.buffer;

import cern.colt.PersistentObject;
import cern.colt.buffer.IntBufferConsumer;
import cern.colt.list.IntArrayList;

public class IntBuffer
extends PersistentObject
implements IntBufferConsumer {
    protected IntBufferConsumer target;
    protected int[] elements;
    protected IntArrayList list;
    protected int capacity;
    protected int size;

    public IntBuffer(IntBufferConsumer intBufferConsumer, int n) {
        this.target = intBufferConsumer;
        this.capacity = n;
        this.elements = new int[n];
        this.list = new IntArrayList(this.elements);
        this.size = 0;
    }

    public void add(int n) {
        if (this.size == this.capacity) {
            this.flush();
        }
        this.elements[this.size++] = n;
    }

    @Override
    public void addAllOf(IntArrayList intArrayList) {
        int n = intArrayList.size();
        if (this.size + n >= this.capacity) {
            this.flush();
        }
        this.target.addAllOf(intArrayList);
    }

    public void clear() {
        this.size = 0;
    }

    public void flush() {
        if (this.size > 0) {
            this.list.setSize(this.size);
            this.target.addAllOf(this.list);
            this.size = 0;
        }
    }
}

