/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.tools.dataset_converter;

import ca.pfv.spmf.input.sequence_database_array_integers.Sequence;
import ca.pfv.spmf.input.sequence_database_array_integers.SequenceDatabase;
import ca.pfv.spmf.tools.dataset_converter.Formats;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class TransactionDatabaseConverter {
    String input;
    String output;
    int lineCount = 0;

    public void convert(String input, String output, Formats inputFileformat, int lineCount) throws IOException {
        this.input = input;
        this.output = output;
        this.lineCount = lineCount;
        if (inputFileformat.equals((Object)Formats.CSV_INTEGER)) {
            this.convertCSV();
        } else if (inputFileformat.equals((Object)Formats.ARFF)) {
            this.convertARFF(true, false);
        } else if (inputFileformat.equals((Object)Formats.ARFF_WITH_MISSING_VALUES)) {
            this.convertARFF(false, false);
        } else if (inputFileformat.equals((Object)Formats.SPMF_SEQUENCE_DB)) {
            this.convertSequenceDB();
        }
    }

    public Map<Integer, String> convertARFFandReturnMap(String inputFile, String outputFile, int lineCount) throws IOException {
        this.input = inputFile;
        this.output = outputFile;
        this.lineCount = lineCount;
        return this.convertARFF(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Integer, String> convertARFF(boolean ignoreMissingValues, boolean returnMapItemIDValue) throws IOException {
        HashMap<Integer, String> mapItemsIDsToAttributeValues = null;
        if (returnMapItemIDValue) {
            mapItemsIDsToAttributeValues = new HashMap<Integer, String>();
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.output));
        try (BufferedReader myInput = null;){
            String thisLine;
            FileInputStream fin = new FileInputStream(new File(this.input));
            myInput = new BufferedReader(new InputStreamReader(fin));
            int count = 0;
            int attributeCount = 0;
            int lastItemAdded = 0;
            ArrayList mapAttributeValuesItemsID = null;
            ArrayList<String> listAttributeNames = new ArrayList<String>();
            while ((thisLine = myInput.readLine()) != null) {
                Integer itemID;
                int i;
                if (thisLine.length() < 2 || thisLine.startsWith("%")) continue;
                int indexComment = thisLine.indexOf(37);
                if (indexComment >= 0) {
                    thisLine = thisLine.substring(0, indexComment);
                }
                if (thisLine.startsWith("@RELATION") || thisLine.startsWith("@relation")) {
                    String relationName = thisLine.split(" ")[1];
                    if (relationName.contains("'")) {
                        relationName = relationName.split("'")[1];
                    }
                    if (returnMapItemIDValue) continue;
                    writer.write("@CONVERTED_FROM_ARFF");
                    writer.newLine();
                    writer.write("@RELATION_NAME=");
                    writer.write(relationName + "=");
                    writer.newLine();
                    continue;
                }
                if (thisLine.startsWith("@ATTRIBUTE") || thisLine.startsWith("@attribute")) {
                    String attributeName;
                    ++attributeCount;
                    if (!returnMapItemIDValue) {
                        writer.write("@ATTRIBUTE=");
                    }
                    int firstPositionOfAttributeName = thisLine.indexOf(32) + 1;
                    boolean useQuotes = false;
                    if (thisLine.charAt(firstPositionOfAttributeName) == '\'') {
                        useQuotes = true;
                        ++firstPositionOfAttributeName;
                    }
                    thisLine = thisLine.substring(firstPositionOfAttributeName);
                    thisLine = thisLine.trim();
                    if (useQuotes) {
                        int quotePosition = thisLine.indexOf(39);
                        attributeName = thisLine.substring(0, quotePosition);
                        if (!returnMapItemIDValue) {
                            writer.write(attributeName + "=");
                        }
                        listAttributeNames.add(attributeName);
                        thisLine = thisLine.substring(quotePosition + 1);
                    } else {
                        int spacePosition = thisLine.indexOf(32);
                        attributeName = thisLine.substring(0, spacePosition);
                        if (!returnMapItemIDValue) {
                            writer.write(attributeName + "=");
                        }
                        listAttributeNames.add(attributeName);
                        thisLine = thisLine.substring(spacePosition + 1);
                    }
                    String type = thisLine = thisLine.trim();
                    if (type.startsWith("{")) {
                        if (!returnMapItemIDValue) {
                            writer.write("ENUMERATION=");
                        }
                        thisLine = thisLine.substring(1, thisLine.length() - 1);
                        for (String token : thisLine.split(",")) {
                            token = token.trim();
                            if (returnMapItemIDValue) continue;
                            writer.write(token + "=");
                        }
                    } else if (!returnMapItemIDValue) {
                        writer.write(type + "=");
                    }
                    if (returnMapItemIDValue) continue;
                    writer.newLine();
                    continue;
                }
                if (thisLine.startsWith("@data") || thisLine.startsWith("@DATA")) {
                    mapAttributeValuesItemsID = new ArrayList(attributeCount);
                    for (int i2 = 0; i2 < attributeCount; ++i2) {
                        mapAttributeValuesItemsID.add(new HashMap());
                    }
                    continue;
                }
                ArrayList<Integer> transaction = new ArrayList<Integer>();
                StringBuffer unseenAttributeValues = new StringBuffer();
                if (thisLine.startsWith("{")) {
                    thisLine = thisLine.substring(1).trim();
                    thisLine = thisLine.substring(0, thisLine.length() - 1).trim();
                    HashSet<Integer> positionProcessed = new HashSet<Integer>();
                    for (String entry : thisLine.split(",")) {
                        entry = entry.trim();
                        int indexOfFirstSpace = entry.indexOf(32);
                        int i3 = Integer.parseInt(entry.substring(0, indexOfFirstSpace));
                        String val = entry.substring(indexOfFirstSpace + 1);
                        positionProcessed.add(i3);
                        if ("?".equals(val) && ignoreMissingValues) continue;
                        Map mapValueToItemID = (Map)mapAttributeValuesItemsID.get(i3);
                        Integer itemID2 = (Integer)mapValueToItemID.get(val);
                        if (itemID2 == null) {
                            itemID2 = ++lastItemAdded;
                            mapValueToItemID.put(val, itemID2);
                            if (mapItemsIDsToAttributeValues != null) {
                                mapItemsIDsToAttributeValues.put(itemID2, (String)listAttributeNames.get(i3) + "=" + val);
                            }
                            unseenAttributeValues.append("@ITEM=" + itemID2 + "=" + (String)listAttributeNames.get(i3) + "=" + val + "\n");
                        }
                        transaction.add(itemID2);
                    }
                    for (i = 0; i < attributeCount; ++i) {
                        String val;
                        if (positionProcessed.contains(i) || "?".equals(val = "0") && ignoreMissingValues) continue;
                        Map mapValueToItemID = (Map)mapAttributeValuesItemsID.get(i);
                        itemID = (Integer)mapValueToItemID.get(val);
                        if (itemID == null) {
                            itemID = ++lastItemAdded;
                            mapValueToItemID.put(val, itemID);
                            if (mapItemsIDsToAttributeValues != null) {
                                mapItemsIDsToAttributeValues.put(itemID, (String)listAttributeNames.get(i) + "=" + val);
                            }
                            unseenAttributeValues.append("@ITEM=" + itemID + "=" + (String)listAttributeNames.get(i) + "=" + val + "\n");
                        }
                        transaction.add(itemID);
                    }
                } else {
                    String[] split = thisLine.split(",");
                    for (i = 0; i < attributeCount; ++i) {
                        String val = split[i].trim();
                        if ("?".equals(val) && ignoreMissingValues) continue;
                        Map mapValueToItemID = (Map)mapAttributeValuesItemsID.get(i);
                        itemID = (Integer)mapValueToItemID.get(val);
                        if (itemID == null) {
                            itemID = ++lastItemAdded;
                            mapValueToItemID.put(val, itemID);
                            if (mapItemsIDsToAttributeValues != null) {
                                mapItemsIDsToAttributeValues.put(itemID, (String)listAttributeNames.get(i) + "=" + val);
                            }
                            unseenAttributeValues.append("@ITEM=" + itemID + "=" + (String)listAttributeNames.get(i) + "=" + val + "\n");
                        }
                        transaction.add(itemID);
                    }
                }
                Collections.sort(transaction);
                writer.write(unseenAttributeValues.toString());
                for (int i4 = 0; i4 < transaction.size(); ++i4) {
                    if (i4 != transaction.size() - 1) {
                        writer.write(transaction.get(i4) + " ");
                        continue;
                    }
                    writer.write(transaction.get(i4) + "");
                }
                writer.newLine();
                if (++count != this.lineCount) continue;
                break;
            }
            writer.close();
        }
        return mapItemsIDsToAttributeValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertCSV() throws IOException {
        try (BufferedReader myInput = null;){
            String thisLine;
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.output));
            FileInputStream fin = new FileInputStream(new File(this.input));
            myInput = new BufferedReader(new InputStreamReader(fin));
            int count = 0;
            while ((thisLine = myInput.readLine()) != null) {
                if (count != 0) {
                    writer.newLine();
                }
                String[] split = thisLine.split(",");
                HashSet<Integer> values = new HashSet<Integer>();
                for (int i = 0; i < split.length; ++i) {
                    values.add(Integer.parseInt(split[i]));
                }
                ArrayList listValues = new ArrayList(values);
                Collections.sort(listValues);
                for (int i = 0; i < listValues.size(); ++i) {
                    if (i != listValues.size() - 1) {
                        writer.write(listValues.get(i) + " ");
                        continue;
                    }
                    writer.write(listValues.get(i) + "");
                }
                if (++count != this.lineCount) continue;
                break;
            }
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertSequenceDB() throws IOException {
        SequenceDatabase database = new SequenceDatabase();
        database.loadFile(this.input);
        try (BufferedReader myInput = null;){
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.output));
            for (int i = 0; i < database.getSequences().size(); ++i) {
                Sequence sequence = database.getSequences().get(i);
                HashSet<Integer> itemsInSequence = new HashSet<Integer>();
                ArrayList<Integer> transaction = new ArrayList<Integer>();
                for (Integer[] itemset : sequence.getItemsets()) {
                    for (Integer item : itemset) {
                        if (itemsInSequence.contains(item)) continue;
                        transaction.add(item);
                        itemsInSequence.add(item);
                    }
                }
                Collections.sort(transaction);
                for (int j = 0; j < transaction.size(); ++j) {
                    writer.write(transaction.get(j) + " ");
                }
                if (i + 1 == this.lineCount) break;
                if (i == database.size() - 1) continue;
                writer.newLine();
            }
            writer.close();
        }
    }
}

