/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.spam;

import ca.pfv.spmf.algorithms.sequentialpatterns.spam.Bitmap;
import ca.pfv.spmf.algorithms.sequentialpatterns.spam.Prefix;
import ca.pfv.spmf.patterns.itemset_list_integers_without_support.Itemset;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AlgoSPAM {
    private long startTime;
    private long endTime;
    private int patternCount;
    private int minsup = 0;
    BufferedWriter writer = null;
    Map<Integer, Bitmap> verticalDB = new HashMap<Integer, Bitmap>();
    List<Integer> sequencesSize = null;
    int lastBitIndex = 0;
    private int maximumPatternLength = Integer.MAX_VALUE;

    public void runAlgorithm(String input, String outputFilePath, double minsupRel) throws IOException {
        this.writer = new BufferedWriter(new FileWriter(outputFilePath));
        this.patternCount = 0;
        MemoryLogger.getInstance().reset();
        this.startTime = System.currentTimeMillis();
        this.spam(input, minsupRel);
        this.endTime = System.currentTimeMillis();
        this.writer.close();
    }

    private void spam(String input, double minsupRel) throws IOException {
        String thisLine;
        BufferedReader reader;
        FileInputStream fin;
        this.verticalDB = new HashMap<Integer, Bitmap>();
        this.sequencesSize = new ArrayList<Integer>();
        this.lastBitIndex = 0;
        try {
            fin = new FileInputStream(new File(input));
            reader = new BufferedReader(new InputStreamReader(fin));
            int bitIndex = 0;
            while ((thisLine = reader.readLine()) != null) {
                if (thisLine.isEmpty() || thisLine.charAt(0) == '#' || thisLine.charAt(0) == '%' || thisLine.charAt(0) == '@') continue;
                this.sequencesSize.add(bitIndex);
                for (String token : thisLine.split(" ")) {
                    if (!token.equals("-1")) continue;
                    ++bitIndex;
                }
            }
            this.lastBitIndex = bitIndex - 1;
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.minsup = (int)Math.ceil(minsupRel * (double)this.sequencesSize.size());
        if (this.minsup == 0) {
            this.minsup = 1;
        }
        try {
            fin = new FileInputStream(new File(input));
            reader = new BufferedReader(new InputStreamReader(fin));
            int sid = 0;
            int tid = 0;
            while ((thisLine = reader.readLine()) != null) {
                for (String token : thisLine.split(" ")) {
                    if (token.equals("-1")) {
                        ++tid;
                        continue;
                    }
                    if (token.equals("-2")) {
                        ++sid;
                        tid = 0;
                        continue;
                    }
                    Integer item = Integer.parseInt(token);
                    Bitmap bitmapItem = this.verticalDB.get(item);
                    if (bitmapItem == null) {
                        bitmapItem = new Bitmap(this.lastBitIndex);
                        this.verticalDB.put(item, bitmapItem);
                    }
                    bitmapItem.registerBit(sid, tid, this.sequencesSize);
                }
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<Integer> frequentItems = new ArrayList<Integer>();
        Iterator<Map.Entry<Integer, Bitmap>> iter = this.verticalDB.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Integer, Bitmap> entry = iter.next();
            if (entry.getValue().getSupport() < this.minsup) {
                iter.remove();
                continue;
            }
            this.savePattern(entry.getKey(), entry.getValue());
            frequentItems.add(entry.getKey());
        }
        if (this.maximumPatternLength == 1) {
            return;
        }
        for (Map.Entry<Integer, Bitmap> entry : this.verticalDB.entrySet()) {
            Prefix prefix = new Prefix();
            prefix.addItemset(new Itemset(entry.getKey()));
            this.dfsPruning(prefix, entry.getValue(), frequentItems, frequentItems, entry.getKey(), 2);
        }
    }

    private void dfsPruning(Prefix prefix, Bitmap prefixBitmap, List<Integer> sn, List<Integer> in, int hasToBeGreaterThanForIStep, int m) throws IOException {
        ArrayList<Integer> sTemp = new ArrayList<Integer>();
        ArrayList<Bitmap> sTempBitmaps = new ArrayList<Bitmap>();
        for (Integer i : sn) {
            Bitmap newBitmap = prefixBitmap.createNewBitmapSStep(this.verticalDB.get(i), this.sequencesSize, this.lastBitIndex);
            if (newBitmap.getSupport() < this.minsup) continue;
            sTemp.add(i);
            sTempBitmaps.add(newBitmap);
        }
        for (int k = 0; k < sTemp.size(); ++k) {
            int item = (Integer)sTemp.get(k);
            Prefix prefixSStep = prefix.cloneSequence();
            prefixSStep.addItemset(new Itemset(item));
            Bitmap newBitmap = (Bitmap)sTempBitmaps.get(k);
            this.savePattern(prefixSStep, newBitmap);
            if (this.maximumPatternLength <= m) continue;
            this.dfsPruning(prefixSStep, newBitmap, sTemp, sTemp, item, m + 1);
        }
        ArrayList<Integer> iTemp = new ArrayList<Integer>();
        ArrayList<Bitmap> iTempBitmaps = new ArrayList<Bitmap>();
        for (Integer i : in) {
            Bitmap newBitmap;
            if (i <= hasToBeGreaterThanForIStep || (newBitmap = prefixBitmap.createNewBitmapIStep(this.verticalDB.get(i), this.sequencesSize, this.lastBitIndex)).getSupport() < this.minsup) continue;
            iTemp.add(i);
            iTempBitmaps.add(newBitmap);
        }
        for (int k = 0; k < iTemp.size(); ++k) {
            int item = (Integer)iTemp.get(k);
            Prefix prefixIStep = prefix.cloneSequence();
            prefixIStep.getItemsets().get(prefixIStep.size() - 1).addItem(item);
            Bitmap newBitmap = (Bitmap)iTempBitmaps.get(k);
            this.savePattern(prefixIStep, newBitmap);
            if (this.maximumPatternLength <= m) continue;
            this.dfsPruning(prefixIStep, newBitmap, sTemp, iTemp, item, m + 1);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private void savePattern(Integer item, Bitmap bitmap) throws IOException {
        ++this.patternCount;
        StringBuffer r = new StringBuffer("");
        r.append(item);
        r.append(" -1 ");
        r.append("SUP: ");
        r.append(bitmap.getSupport());
        this.writer.write(r.toString());
        this.writer.newLine();
    }

    private void savePattern(Prefix prefix, Bitmap bitmap) throws IOException {
        ++this.patternCount;
        StringBuffer r = new StringBuffer("");
        for (Itemset itemset : prefix.getItemsets()) {
            for (Integer item : itemset.getItems()) {
                String string = item.toString();
                r.append(string);
                r.append(' ');
            }
            r.append("-1 ");
        }
        r.append("SUP: ");
        r.append(bitmap.getSupport());
        this.writer.write(r.toString());
        this.writer.newLine();
    }

    public void printStatistics() {
        StringBuffer r = new StringBuffer(200);
        r.append("=============  Algorithm - STATISTICS =============\n Total time ~ ");
        r.append(this.endTime - this.startTime);
        r.append(" ms\n");
        r.append(" Frequent sequences count : " + this.patternCount);
        r.append('\n');
        r.append(" Max memory (mb) : ");
        r.append(MemoryLogger.getInstance().getMaxMemory());
        r.append(this.patternCount);
        r.append('\n');
        r.append("minsup " + this.minsup);
        r.append('\n');
        r.append("===================================================\n");
        System.out.println(r.toString());
    }

    public int getMaximumPatternLength() {
        return this.maximumPatternLength;
    }

    public void setMaximumPatternLength(int maximumPatternLength) {
        this.maximumPatternLength = maximumPatternLength;
    }
}

