/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.lapin;

import ca.pfv.spmf.algorithms.sequentialpatterns.lapin.IEPositionList;
import ca.pfv.spmf.algorithms.sequentialpatterns.lapin.PositionVector;
import ca.pfv.spmf.algorithms.sequentialpatterns.lapin.Prefix;
import ca.pfv.spmf.algorithms.sequentialpatterns.lapin.SEPositionList;
import ca.pfv.spmf.algorithms.sequentialpatterns.lapin.Table;
import ca.pfv.spmf.datastructures.triangularmatrix.AbstractTriangularMatrix;
import ca.pfv.spmf.datastructures.triangularmatrix.SparseTriangularMatrix;
import ca.pfv.spmf.input.sequence_database_array_integers.SequenceDatabase;
import ca.pfv.spmf.tools.MemoryLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class AlgoLAPIN_LCI {
    private long startTime;
    private long endTime;
    private int patternCount;
    private int minsup = 0;
    BufferedWriter writer = null;
    Table[] tables = null;
    SEPositionList[] sePositionList;
    IEPositionList[] iePositionList;
    final boolean DEBUG = false;
    SequenceDatabase seqDB = null;
    private AbstractTriangularMatrix matrixPairCount;
    String input;

    public void runAlgorithm(String input, String outputFilePath, double minsupRel) throws IOException {
        this.input = input;
        this.writer = new BufferedWriter(new FileWriter(outputFilePath));
        this.patternCount = 0;
        MemoryLogger.getInstance().reset();
        this.startTime = System.currentTimeMillis();
        this.lapin(input, minsupRel);
        this.endTime = System.currentTimeMillis();
        this.writer.close();
    }

    private void lapin(String input, double minsupRel) throws IOException {
        String thisLine;
        BufferedReader reader;
        int sequenceCount = 0;
        int largestItemID = 0;
        HashMap mapItemFirstOccurrences = new HashMap();
        try {
            String thisLine2;
            BufferedReader reader2 = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            while ((thisLine2 = reader2.readLine()) != null) {
                HashSet<Integer> itemsAlreadySeen = new HashSet<Integer>();
                short itemsetID = 0;
                for (String integer : thisLine2.split(" ")) {
                    Integer item;
                    if ("-1".equals(integer)) {
                        itemsetID = (short)(itemsetID + 1);
                        continue;
                    }
                    if ("-2".equals(integer) || itemsAlreadySeen.contains(item = Integer.valueOf(integer))) continue;
                    ArrayList<Position> list = (ArrayList<Position>)mapItemFirstOccurrences.get(item);
                    if (list == null) {
                        list = new ArrayList<Position>();
                        mapItemFirstOccurrences.put(item, list);
                    }
                    Position position = new Position(sequenceCount, itemsetID);
                    list.add(position);
                    itemsAlreadySeen.add(item);
                    if (item <= largestItemID) continue;
                    largestItemID = item;
                }
                ++sequenceCount;
            }
            reader2.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.tables = new Table[sequenceCount];
        this.minsup = (int)Math.ceil(minsupRel * (double)sequenceCount);
        if (this.minsup == 0) {
            this.minsup = 1;
        }
        ArrayList<Integer> frequentItems = new ArrayList<Integer>();
        for (Map.Entry entry : mapItemFirstOccurrences.entrySet()) {
            List itemBorder = (List)entry.getValue();
            if (itemBorder.size() < this.minsup) continue;
            Integer item = (Integer)entry.getKey();
            this.savePattern(item, itemBorder.size());
            frequentItems.add(item);
        }
        Collections.sort(frequentItems);
        this.matrixPairCount = new SparseTriangularMatrix(largestItemID + 1);
        this.sePositionList = new SEPositionList[sequenceCount];
        this.iePositionList = new IEPositionList[sequenceCount];
        try {
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            int currentSequenceID = 0;
            while ((thisLine = reader.readLine()) != null) {
                SparseTriangularMatrix matrixPairLastSeenInSID = new SparseTriangularMatrix(largestItemID + 1);
                int positionCount = -1;
                for (char caracter : thisLine.toCharArray()) {
                    if (caracter != '-') continue;
                    ++positionCount;
                }
                HashSet<Integer> itemsAlreadySeen = new HashSet<Integer>();
                Table table = new Table();
                BitSet currentBitset = new BitSet(mapItemFirstOccurrences.size());
                boolean seenNewItem = false;
                String[] tokens = thisLine.split(" ");
                int currentPosition = positionCount;
                ArrayList<Integer> currentItemset = new ArrayList<Integer>();
                for (int i = tokens.length - 1; i >= 0; --i) {
                    Integer item;
                    String token = tokens[i];
                    if ("-1".equals(token)) {
                        for (int k = 0; k < currentItemset.size(); ++k) {
                            Integer item1 = (Integer)currentItemset.get(k);
                            for (int m = k + 1; m < currentItemset.size(); ++m) {
                                Integer item2 = (Integer)currentItemset.get(m);
                                int sid = matrixPairLastSeenInSID.getSupportForItems(item1, item2);
                                if (sid == currentSequenceID + 1) continue;
                                this.matrixPairCount.incrementCount(item1, item2);
                                matrixPairLastSeenInSID.setSupport(item1, item2, currentSequenceID + 1);
                            }
                        }
                        currentItemset.clear();
                        --currentPosition;
                        if (!seenNewItem) continue;
                        PositionVector vector = new PositionVector(currentPosition, (BitSet)currentBitset.clone());
                        table.add(vector);
                        continue;
                    }
                    if ("-2".equals(token) || ((List)mapItemFirstOccurrences.get(item = Integer.valueOf(token))).size() < this.minsup) continue;
                    if (!itemsAlreadySeen.contains(item)) {
                        seenNewItem = true;
                        itemsAlreadySeen.add(item);
                        currentBitset.set(item);
                    }
                    currentItemset.add(item);
                }
                for (int k = 0; k < currentItemset.size(); ++k) {
                    Integer item1 = (Integer)currentItemset.get(k);
                    for (int m = k + 1; m < currentItemset.size(); ++m) {
                        Integer item2 = (Integer)currentItemset.get(m);
                        int sid = matrixPairLastSeenInSID.getSupportForItems(item1, item2);
                        if (sid == currentSequenceID + 1) continue;
                        this.matrixPairCount.incrementCount(item1, item2);
                        matrixPairLastSeenInSID.setSupport(item1, item2, currentSequenceID + 1);
                    }
                }
                if (seenNewItem) {
                    PositionVector vector = new PositionVector(-1, (BitSet)currentBitset.clone());
                    table.add(vector);
                }
                this.sePositionList[currentSequenceID] = new SEPositionList(itemsAlreadySeen);
                this.iePositionList[currentSequenceID] = new IEPositionList();
                this.tables[currentSequenceID] = table;
                ++currentSequenceID;
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(new File(input))));
            int currentSequenceID = 0;
            while ((thisLine = reader.readLine()) != null) {
                String[] tokens = thisLine.split(" ");
                ArrayList<Integer> currentItemset = new ArrayList<Integer>();
                short itemsetID = 0;
                currentItemset.clear();
                for (int i = 0; i < tokens.length; ++i) {
                    Integer item;
                    String token = tokens[i];
                    if ("-1".equals(token)) {
                        if (currentItemset.size() > 1) {
                            for (int k = 0; k < currentItemset.size(); ++k) {
                                Integer item1 = (Integer)currentItemset.get(k);
                                for (int m = k + 1; m < currentItemset.size(); ++m) {
                                    Integer item2 = (Integer)currentItemset.get(m);
                                    int support = this.matrixPairCount.getSupportForItems(item1, item2);
                                    if (support < this.minsup) continue;
                                    this.iePositionList[currentSequenceID].register(item1, item2, itemsetID);
                                }
                            }
                        }
                        itemsetID = (short)(itemsetID + 1);
                        currentItemset.clear();
                        continue;
                    }
                    if ("-2".equals(token) || ((List)mapItemFirstOccurrences.get(item = Integer.valueOf(token))).size() < this.minsup) continue;
                    this.sePositionList[currentSequenceID].register(item, itemsetID);
                    currentItemset.add(item);
                }
                this.iePositionList[currentSequenceID].sort();
                ++currentSequenceID;
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int i = 0; i < frequentItems.size(); ++i) {
            int item1 = (Integer)frequentItems.get(i);
            List item1Border = (List)mapItemFirstOccurrences.get(item1);
            if (item1Border.size() >= this.minsup) {
                Prefix prefix = new Prefix();
                ArrayList<Integer> itemset = new ArrayList<Integer>(1);
                itemset.add(item1);
                prefix.itemsets.add(itemset);
                this.genPatterns(prefix, item1Border, frequentItems, frequentItems, item1, true);
            }
            for (int k = i + 1; k < frequentItems.size(); ++k) {
                int item2 = (Integer)frequentItems.get(k);
                int support = this.matrixPairCount.getSupportForItems(item1, item2);
                if (support < this.minsup) continue;
                List item2Border = (List)mapItemFirstOccurrences.get(item2);
                ArrayList<Position> ie12Border = new ArrayList<Position>();
                List borderToUse = item2Border.size() < item1Border.size() ? item2Border : item1Border;
                block22: for (Position sequenceToUse : borderToUse) {
                    int sid = sequenceToUse.sid;
                    List<Short> listPosition1 = this.sePositionList[sid].getListForItem(item1);
                    List<Short> listPosition2 = this.sePositionList[sid].getListForItem(item2);
                    if (listPosition1 == null || listPosition2 == null) continue;
                    int index1 = 0;
                    int index2 = 0;
                    while (index1 < listPosition1.size() && index2 < listPosition2.size()) {
                        short position2;
                        short position1 = listPosition1.get(index1);
                        if (position1 < (position2 = listPosition2.get(index2).shortValue())) {
                            ++index1;
                            continue;
                        }
                        if (position1 > position2) {
                            ++index2;
                            continue;
                        }
                        ie12Border.add(new Position(sid, position1));
                        continue block22;
                    }
                }
                Prefix prefix = new Prefix();
                ArrayList<Integer> itemset = new ArrayList<Integer>(2);
                itemset.add(item1);
                itemset.add(item2);
                prefix.itemsets.add(itemset);
                this.savePattern(prefix, support);
                this.genPatterns(prefix, ie12Border, frequentItems, frequentItems, item2, false);
            }
        }
        MemoryLogger.getInstance().checkMemory();
        this.writer.close();
    }

    private void genPatterns(Prefix prefix, List<Position> prefixBorder, List<Integer> sn, List<Integer> in, int hasToBeGreaterThanForIStep, boolean doNotPerformIExtensions) throws IOException {
        int index;
        ArrayList<Integer> sTemp = new ArrayList<Integer>();
        ArrayList<Integer> sTempSupport = new ArrayList<Integer>();
        for (Integer item : sn) {
            int support = this.calculateSupportSStep(item, prefixBorder);
            if (support < this.minsup) continue;
            sTemp.add(item);
            sTempSupport.add(support);
        }
        for (int k = 0; k < sTemp.size(); ++k) {
            int item = (Integer)sTemp.get(k);
            Prefix prefixSStep = prefix.cloneSequence();
            ArrayList<Integer> itemset = new ArrayList<Integer>(1);
            itemset.add(item);
            prefixSStep.itemsets.add(itemset);
            this.savePattern(prefixSStep, (int)((Integer)sTempSupport.get(k)));
            List<Position> newBorder = this.recalculateBorderForSExtension(prefixBorder, item);
            this.genPatterns(prefixSStep, newBorder, sTemp, sTemp, item, false);
        }
        if (doNotPerformIExtensions) {
            return;
        }
        ArrayList<Integer> iTemp = new ArrayList<Integer>();
        ArrayList<List<Position>> iTempBorder = new ArrayList<List<Position>>();
        for (int i = index = Collections.binarySearch(in, hasToBeGreaterThanForIStep); i < in.size(); ++i) {
            List<Position> newBorder;
            Integer item = in.get(i);
            List<Integer> lastItemset = prefix.itemsets.get(prefix.itemsets.size() - 1);
            Integer lastItem = lastItemset.get(lastItemset.size() - 1);
            boolean willAddSecondItem = lastItemset.size() == 1;
            int support = this.estimateSupportIStep(item, prefixBorder);
            if (support < this.minsup || (newBorder = this.recalculateBorderForIExtension(lastItemset, prefixBorder, hasToBeGreaterThanForIStep, item, willAddSecondItem)).size() < this.minsup) continue;
            iTemp.add(item);
            iTempBorder.add(newBorder);
        }
        for (int k = 0; k < iTemp.size(); ++k) {
            int item = (Integer)iTemp.get(k);
            Prefix prefixIStep = prefix.cloneSequence();
            prefixIStep.itemsets.get(prefixIStep.size() - 1).add(item);
            List newBorder = (List)iTempBorder.get(k);
            this.savePattern(prefixIStep, newBorder.size());
            this.genPatterns(prefixIStep, newBorder, sTemp, iTemp, item, false);
        }
        MemoryLogger.getInstance().checkMemory();
    }

    private List<Position> recalculateBorderForIExtension(List<Integer> prefixLastItemset, List<Position> prefixBorder, int item1, int item2, boolean willAddSecondItem) {
        ArrayList<Position> newBorder = new ArrayList<Position>();
        block0: for (Position previousPosition : prefixBorder) {
            int sid = previousPosition.sid;
            short previousItemsetID = previousPosition.position;
            IEPositionList positionLists = this.iePositionList[sid];
            List<Short> listPositions = positionLists.getListForPair(item1, item2);
            if (listPositions == null) continue;
            block1: for (short pos : listPositions) {
                if (pos < previousItemsetID) continue;
                if (!willAddSecondItem) {
                    SEPositionList plists = this.sePositionList[sid];
                    for (int i = 0; i < prefixLastItemset.size() - 1; ++i) {
                        Integer itemX = prefixLastItemset.get(i);
                        List<Short> plistX = plists.getListForItem(itemX);
                        int index = Collections.binarySearch(plistX, pos);
                        if (index < 0) continue block1;
                    }
                }
                Position newPosition = new Position(sid, pos);
                newBorder.add(newPosition);
                continue block0;
            }
        }
        return newBorder;
    }

    private int estimateSupportIStep(Integer item, List<Position> itemBorder) {
        int support = 0;
        block0: for (Position pos : itemBorder) {
            Table table = this.tables[pos.sid];
            int numberOfVectors = table.positionVectors.size();
            for (int j = 0; j < numberOfVectors; ++j) {
                PositionVector vector = table.positionVectors.get(j);
                if (vector.position >= pos.position) continue;
                if (!vector.bitset.get(item)) continue block0;
                ++support;
                continue block0;
            }
        }
        return support;
    }

    private int calculateSupportSStep(Integer item, List<Position> itemBorder) {
        int support = 0;
        block0: for (Position pos : itemBorder) {
            Table table = this.tables[pos.sid];
            int numberOfVectors = table.positionVectors.size();
            for (int j = numberOfVectors - 2; j >= 0; --j) {
                PositionVector vector = table.positionVectors.get(j);
                if (vector.position < pos.position) continue;
                if (!vector.bitset.get(item)) continue block0;
                ++support;
                continue block0;
            }
        }
        return support;
    }

    private List<Position> recalculateBorderForSExtension(List<Position> prefixBorder, int item) {
        ArrayList<Position> newBorder = new ArrayList<Position>();
        block0: for (Position previousPosition : prefixBorder) {
            int sid = previousPosition.sid;
            short previousItemsetID = previousPosition.position;
            SEPositionList positionLists = this.sePositionList[sid];
            List<Short> listPositions = positionLists.getListForItem(item);
            if (listPositions == null) continue;
            for (short pos : listPositions) {
                if (pos <= previousItemsetID) continue;
                Position newPosition = new Position(sid, pos);
                newBorder.add(newPosition);
                continue block0;
            }
        }
        return newBorder;
    }

    private void savePattern(Integer item, int support) throws IOException {
        ++this.patternCount;
        StringBuffer r = new StringBuffer("");
        r.append(item);
        r.append(" -1 ");
        r.append("#SUP: ");
        r.append(support);
        this.writer.write(r.toString());
        this.writer.newLine();
    }

    private void savePattern(Prefix prefix, int support) throws IOException {
        ++this.patternCount;
        StringBuffer r = new StringBuffer("");
        for (List<Integer> itemset : prefix.itemsets) {
            for (Integer item : itemset) {
                String string = item.toString();
                r.append(string);
                r.append(' ');
            }
            r.append("-1 ");
        }
        r.append("#SUP: ");
        r.append(support);
        this.writer.write(r.toString());
        this.writer.newLine();
    }

    public void printStatistics() {
        StringBuffer r = new StringBuffer(200);
        r.append("=============  LAPIN - STATISTICS =============\n Total time ~ ");
        r.append(this.endTime - this.startTime);
        r.append(" ms\n");
        r.append(" Frequent sequences count : " + this.patternCount);
        r.append('\n');
        r.append(" Max memory (mb) : ");
        r.append(MemoryLogger.getInstance().getMaxMemory());
        r.append(this.patternCount);
        r.append('\n');
        r.append("===================================================");
        System.out.println(r.toString());
    }

    class Position {
        int sid;
        short position;

        public Position(int sid, short position) {
            this.sid = sid;
            this.position = position;
        }
    }
}

