/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.gsp_AGP.items;

import ca.pfv.spmf.algorithms.sequentialpatterns.gsp_AGP.items.Item;
import ca.pfv.spmf.algorithms.sequentialpatterns.gsp_AGP.items.ItemFactory;
import ca.pfv.spmf.algorithms.sequentialpatterns.gsp_AGP.items.Itemset;
import ca.pfv.spmf.algorithms.sequentialpatterns.gsp_AGP.items.Sequence;
import ca.pfv.spmf.algorithms.sequentialpatterns.gsp_AGP.items.creators.AbstractionCreator;
import ca.pfv.spmf.algorithms.sequentialpatterns.gsp_AGP.items.creators.ItemAbstractionPairCreator;
import ca.pfv.spmf.algorithms.sequentialpatterns.gsp_AGP.items.patterns.Pattern;
import ca.pfv.spmf.algorithms.sequentialpatterns.gsp_AGP.items.patterns.PatternCreator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SequenceDatabase {
    private AbstractionCreator abstractionCreator;
    private Map<Item, Pattern> frequentItems = new HashMap<Item, Pattern>();
    private List<Sequence> sequences = new ArrayList<Sequence>();
    private ItemFactory<Integer> itemFactory = new ItemFactory();
    private PatternCreator patternCreator = PatternCreator.getInstance();

    public SequenceDatabase(AbstractionCreator abstractionCreator) {
        this.abstractionCreator = abstractionCreator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFile(String path, double minSupportAbsolute) throws IOException {
        try (BufferedReader myInput = null;){
            String thisLine;
            FileInputStream fis = new FileInputStream(new File(path));
            myInput = new BufferedReader(new InputStreamReader(fis));
            while ((thisLine = myInput.readLine()) != null) {
                if (thisLine.charAt(0) == '#') continue;
                this.addSequence(thisLine.split(" "));
            }
            double minSupRelative = (int)Math.ceil(minSupportAbsolute * (double)this.sequences.size());
            Set<Item> items = this.frequentItems.keySet();
            HashSet<Item> itemsToRemove = new HashSet<Item>();
            for (Item item : items) {
                Pattern pattern = this.frequentItems.get(item);
                if (!(pattern.getSupport() < minSupRelative)) continue;
                itemsToRemove.add(item);
            }
            for (Item<Object> item : itemsToRemove) {
                this.frequentItems.remove(item);
            }
            this.shrinkDatabase(this.frequentItems.keySet());
        }
    }

    public void addSequence(String[] integers) {
        int start;
        ItemAbstractionPairCreator creadorPares = ItemAbstractionPairCreator.getInstance();
        Sequence sequence = new Sequence(this.sequences.size());
        Itemset itemset = new Itemset();
        for (int i = start = 0; i < integers.length; ++i) {
            if (integers[i].codePointAt(0) == 60) {
                String value = integers[i].substring(1, integers[i].length() - 1);
                long timestamp = Long.parseLong(value);
                itemset.setTimestamp(timestamp);
                continue;
            }
            if (integers[i].equals("-1")) {
                long time = itemset.getTimestamp() + 1L;
                sequence.addItemset(itemset);
                itemset = new Itemset();
                itemset.setTimestamp(time);
                continue;
            }
            if (integers[i].equals("-2")) {
                this.sequences.add(sequence);
                continue;
            }
            Item item = this.itemFactory.getItem(Integer.parseInt(integers[i]));
            Pattern pattern = this.frequentItems.get(item);
            if (pattern == null) {
                pattern = this.patternCreator.createPattern(creadorPares.getItemAbstractionPair(item, this.abstractionCreator.CreateDefaultAbstraction()));
                this.frequentItems.put(item, pattern);
            }
            pattern.addAppearance(sequence.getId());
            itemset.addItem(item);
        }
    }

    public void addSequence(Sequence sequence) {
        this.sequences.add(sequence);
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        for (Sequence sequence : this.sequences) {
            r.append(sequence.getId());
            r.append(":  ");
            r.append(sequence.toString());
            r.append('\n');
        }
        return r.toString();
    }

    public int size() {
        return this.sequences.size();
    }

    public List<Sequence> getSequences() {
        return this.sequences;
    }

    public List<Pattern> frequentItems() {
        ArrayList<Pattern> celdasDeItemsFrecuentes = new ArrayList<Pattern>(this.frequentItems.values());
        Collections.sort(celdasDeItemsFrecuentes);
        return celdasDeItemsFrecuentes;
    }

    public Map<Item, Pattern> getFrequentItems() {
        return this.frequentItems;
    }

    public void clear() {
        if (this.sequences != null) {
            this.sequences.clear();
        }
        this.sequences = null;
        if (this.frequentItems != null) {
            this.frequentItems.clear();
        }
        this.frequentItems = null;
        this.itemFactory = null;
    }

    private void shrinkDatabase(Set<Item> keySet) {
        for (Sequence sequence : this.sequences) {
            for (int i = 0; i < sequence.size(); ++i) {
                Itemset itemset = sequence.get(i);
                for (int j = 0; j < itemset.size(); ++j) {
                    Item item = itemset.get(j);
                    if (keySet.contains(item)) continue;
                    sequence.remove(i, j);
                    --j;
                }
                if (itemset.size() != 0) continue;
                sequence.remove(i);
                --i;
            }
        }
    }
}

