/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.trie;

import ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.abstractions.ItemAbstractionPair;
import ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.patterns.Pattern;
import ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.patterns.PatternCreator;
import ca.pfv.spmf.algorithms.sequentialpatterns.clospan_AGP.items.trie.TrieNode;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;

public class Trie
implements Comparable<Trie> {
    private List<TrieNode> nodes;
    private BitSet appearingIn = new BitSet();
    private int support = -1;
    private int sumSequencesIDs = -1;
    private static int intId = 1;
    private int id;

    public Trie() {
        this.nodes = new ArrayList<TrieNode>();
        this.id = intId++;
    }

    public Trie(List<TrieNode> nodes) {
        this.nodes = nodes;
        this.id = intId++;
    }

    public Trie getChild(int index) {
        return this.nodes.get(index).getChild();
    }

    public void setChild(int index, Trie child) {
        this.nodes.get(index).setChild(child);
    }

    public List<TrieNode> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<TrieNode> nodes) {
        this.nodes = nodes;
    }

    public boolean remove(int index) {
        if (this.levelSize() == 0 || index >= this.levelSize()) {
            return false;
        }
        this.getChild(index).removeAll();
        return true;
    }

    public ItemAbstractionPair getPair(int index) {
        return this.nodes.get(index).getPair();
    }

    public TrieNode getNode(int index) {
        return this.nodes.get(index);
    }

    public void setNode(int index, TrieNode node) {
        this.nodes.set(index, node);
    }

    public int levelSize() {
        if (this.nodes == null) {
            return 0;
        }
        return this.nodes.size();
    }

    public void removeAll() {
        if (this.levelSize() == 0) {
            return;
        }
        for (TrieNode node : this.nodes) {
            Trie currentChild = node.getChild();
            if (currentChild != null) {
                currentChild.removeAll();
            }
            node.setChild(null);
            node.setPair(null);
        }
        this.nodes.clear();
    }

    public void sort() {
        Collections.sort(this.nodes);
    }

    public BitSet getAppearingIn() {
        return this.appearingIn;
    }

    public void setAppearingIn(BitSet appearingIn) {
        this.appearingIn = appearingIn;
    }

    public String toString() {
        if (this.nodes == null) {
            return "";
        }
        StringBuilder result = new StringBuilder("ID=" + this.id + "[");
        if (!this.nodes.isEmpty()) {
            for (TrieNode node : this.nodes) {
                result.append(node.getPair()).append(',');
            }
            result.deleteCharAt(result.length() - 1);
        } else {
            result.append("NULL");
        }
        result.append(']');
        return result.toString();
    }

    public int getSupport() {
        if (this.support < 0) {
            this.support = this.appearingIn.cardinality();
        }
        return this.support;
    }

    public void setSupport(int support) {
        this.support = support;
    }

    public int getSumIdSequences() {
        if (this.sumSequencesIDs < 0) {
            this.sumSequencesIDs = this.calculateSumIdSequences();
        }
        return this.sumSequencesIDs;
    }

    public void setSumIdSequences(int sumIdSequences) {
        this.sumSequencesIDs = sumIdSequences;
    }

    private int calculateSumIdSequences() {
        int acum = 0;
        int i = this.appearingIn.nextSetBit(0);
        while (i >= 0) {
            acum += i;
            i = this.appearingIn.nextSetBit(i + 1);
        }
        return acum;
    }

    public List<Pattern> preorderTraversal(Pattern p) {
        LinkedList<Pattern> result = new LinkedList<Pattern>();
        if (this.nodes != null) {
            for (TrieNode node : this.nodes) {
                List<Pattern> patternsFromChild;
                Trie child = node.getChild();
                Pattern newPattern = PatternCreator.getInstance().concatenate(p, node.getPair());
                newPattern.setAppearingIn(child.getAppearingIn());
                result.add(newPattern);
                if (child == null || (patternsFromChild = child.preorderTraversal(newPattern)) == null) continue;
                result.addAll(patternsFromChild);
            }
            return result;
        }
        return null;
    }

    public void display(DefaultTreeModel model, MutableTreeNode p) {
        if (this.nodes != null) {
            for (int i = 0; i < this.nodes.size(); ++i) {
                TrieNode node = this.nodes.get(i);
                Trie child = node.getChild();
                DefaultMutableTreeNode currentNode = new DefaultMutableTreeNode(node.getPair().toString() + child.appearingIn);
                model.insertNodeInto(currentNode, p, i);
                child.display(model, currentNode);
            }
        }
    }

    @Override
    public int compareTo(Trie t) {
        return new Integer(this.id).compareTo(t.id);
    }

    public void addNode(TrieNode node) {
        if (this.nodes == null) {
            this.nodes = new ArrayList<TrieNode>();
        }
        this.nodes.add(node);
    }
}

