/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.upgrowth_ihup;

import ca.pfv.spmf.algorithms.frequentpatterns.upgrowth_ihup.Item;
import ca.pfv.spmf.algorithms.frequentpatterns.upgrowth_ihup.UPNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IHUPTree {
    List<Integer> headerList = null;
    boolean hasMoreThanOnePath = false;
    Map<Integer, UPNode> mapItemNodes = new HashMap<Integer, UPNode>();
    UPNode root = new UPNode();
    Map<Integer, UPNode> mapItemLastNode = new HashMap<Integer, UPNode>();

    public void addTransaction(List<Item> transaction, int RTU) {
        UPNode currentNode = this.root;
        for (int i = 0; i < transaction.size(); ++i) {
            int item = transaction.get(i).getName();
            UPNode child = currentNode.getChildWithID(item);
            if (child == null) {
                int nodeUtility = RTU;
                currentNode = this.insertNewNode(currentNode, item, nodeUtility);
                continue;
            }
            int currentNU = child.nodeUtility;
            int nodeUtility = currentNU + RTU;
            ++child.count;
            child.nodeUtility = nodeUtility;
            currentNode = child;
        }
    }

    public void addLocalTransaction(List<Integer> localPath, int pathUtility) {
        UPNode currentlocalNode = this.root;
        for (int i = 0; i < localPath.size(); ++i) {
            int item = localPath.get(i);
            UPNode child = currentlocalNode.getChildWithID(item);
            if (child == null) {
                int nodeUtility = pathUtility;
                currentlocalNode = this.insertNewNode(currentlocalNode, item, nodeUtility);
                continue;
            }
            int currentNU = child.nodeUtility;
            int nodeUtility = currentNU + pathUtility;
            ++child.count;
            child.nodeUtility = nodeUtility;
            currentlocalNode = child;
        }
    }

    private UPNode insertNewNode(UPNode currentlocalNode, int item, int nodeUtility) {
        UPNode localheadernode;
        UPNode newNode = new UPNode();
        newNode.itemID = item;
        newNode.nodeUtility = nodeUtility;
        newNode.count = 1;
        newNode.parent = currentlocalNode;
        currentlocalNode.childs.add(newNode);
        if (!this.hasMoreThanOnePath && currentlocalNode.childs.size() > 1) {
            this.hasMoreThanOnePath = true;
        }
        if ((localheadernode = this.mapItemNodes.get(item)) == null) {
            this.mapItemNodes.put(item, newNode);
            this.mapItemLastNode.put(item, newNode);
        } else {
            UPNode lastNode = this.mapItemLastNode.get(item);
            lastNode.nodeLink = newNode;
            this.mapItemLastNode.put(item, newNode);
        }
        return newNode;
    }

    void createHeaderList(final Map<Integer, Integer> mapItemToTWU) {
        this.headerList = new ArrayList<Integer>(this.mapItemNodes.keySet());
        Collections.sort(this.headerList, new Comparator<Integer>(){

            @Override
            public int compare(Integer id1, Integer id2) {
                int compare = (Integer)mapItemToTWU.get(id2) - (Integer)mapItemToTWU.get(id1);
                if (compare == 0) {
                    return id1 - id2;
                }
                return compare;
            }
        });
    }

    public String toString() {
        String output = "";
        output = output + "HEADER TABLE: " + this.mapItemNodes + " \n";
        output = output + "hasMoreThanOnePath: " + this.hasMoreThanOnePath + " \n";
        return output + this.toString("", this.root);
    }

    public String toString(String indent, UPNode node) {
        String output = indent + node.toString() + "\n";
        String childsOutput = "";
        for (UPNode child : node.childs) {
            childsOutput = childsOutput + this.toString(indent + " ", child);
        }
        return output + childsOutput;
    }
}

