/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.frequentpatterns.estDec;

import java.util.ArrayList;
import java.util.List;

public class estNode {
    Integer itemID;
    double counter;
    int tid;
    List<estNode> children;

    estNode(Integer item, double count, int k) {
        this.itemID = item;
        this.counter = count;
        this.tid = k;
        this.children = new ArrayList<estNode>();
    }

    estNode() {
        this.itemID = -1;
        this.counter = 0.0;
        this.tid = 0;
        this.children = new ArrayList<estNode>();
    }

    public estNode getChildWithID(int id) {
        if (this.children == null) {
            return null;
        }
        for (estNode child : this.children) {
            if (child.itemID != id) continue;
            return child;
        }
        return null;
    }

    public int getChildIndexWithID(int id) {
        if (this.children == null) {
            return -1;
        }
        int i = 0;
        for (estNode child : this.children) {
            if (child.itemID == id) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void update(int k, int value, double d) {
        this.counter = this.counter * Math.pow(d, k - this.tid) + (double)value;
        this.tid = k;
    }

    public double computeSupport(double N) {
        return this.counter / N;
    }
}

