/*
 * Decompiled with CFR 0.152.
 */
package ca.pfv.spmf.algorithms.associationrules.Indirect;

import ca.pfv.spmf.patterns.itemset_array_integers_with_tids.Itemset;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AlgoINDIRECT {
    Map<Integer, Set<Integer>> mapItemTIDS = new HashMap<Integer, Set<Integer>>();
    int minSuppRelative;
    double minconf = 0.0;
    double tsRelative = 0.0;
    long startTimestamp = 0L;
    long endTimeStamp = 0L;
    BufferedWriter writer = null;
    private int ruleCount;
    private int tidcount = 0;

    public void runAlgorithm(String input, String output, double minsup, double ts, double minconf) throws NumberFormatException, IOException {
        String line;
        this.startTimestamp = System.currentTimeMillis();
        this.writer = new BufferedWriter(new FileWriter(output));
        this.minconf = minconf;
        this.mapItemTIDS = new HashMap<Integer, Set<Integer>>();
        BufferedReader reader = new BufferedReader(new FileReader(input));
        this.tidcount = 0;
        while ((line = reader.readLine()) != null) {
            String[] lineSplited;
            if (line.isEmpty() || line.charAt(0) == '#' || line.charAt(0) == '%' || line.charAt(0) == '@') continue;
            for (String stringItem : lineSplited = line.split(" ")) {
                int item = Integer.parseInt(stringItem);
                Set<Integer> tids = this.mapItemTIDS.get(item);
                if (tids == null) {
                    tids = new HashSet<Integer>();
                    this.mapItemTIDS.put(item, tids);
                }
                tids.add(this.tidcount);
            }
            ++this.tidcount;
        }
        reader.close();
        this.minSuppRelative = (int)Math.ceil(minsup * (double)this.tidcount);
        this.tsRelative = (int)Math.ceil(ts * (double)this.tidcount);
        int k = 1;
        List<Itemset> level = new ArrayList<Itemset>();
        Iterator<Map.Entry<Integer, Set<Integer>>> iterator = this.mapItemTIDS.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, Set<Integer>> entry = iterator.next();
            if (entry.getValue().size() >= this.minSuppRelative) {
                Integer item = entry.getKey();
                Itemset itemset = new Itemset(item);
                itemset.setTIDs(this.mapItemTIDS.get(item));
                level.add(itemset);
                continue;
            }
            iterator.remove();
        }
        Collections.sort(level, new Comparator<Itemset>(){

            @Override
            public int compare(Itemset o1, Itemset o2) {
                return o1.get(0) - o2.get(0);
            }
        });
        k = 2;
        while (!level.isEmpty()) {
            level = this.generateCandidateSizeK(level, k);
            ++k;
        }
        this.writer.close();
        this.endTimeStamp = System.currentTimeMillis();
    }

    protected List<Itemset> generateCandidateSizeK(List<Itemset> levelK_1, int level) throws IOException {
        int i;
        ArrayList<Itemset> nextLevel = new ArrayList<Itemset>();
        block0: for (i = 0; i < levelK_1.size(); ++i) {
            Itemset itemset1 = levelK_1.get(i);
            block1: for (int j = i + 1; j < levelK_1.size(); ++j) {
                Itemset itemset2 = levelK_1.get(j);
                for (int k = 0; k < itemset1.size(); ++k) {
                    if (k == itemset1.size() - 1) {
                        if (itemset1.getItems()[k] < itemset2.get(k)) continue;
                        continue block0;
                    }
                    if (itemset1.getItems()[k] < itemset2.get(k)) continue block1;
                    if (itemset1.getItems()[k] > itemset2.get(k)) continue block0;
                }
                HashSet<Integer> list = new HashSet<Integer>();
                for (Integer val1 : itemset1.getTransactionsIds()) {
                    if (!itemset2.getTransactionsIds().contains(val1)) continue;
                    list.add(val1);
                }
                if (list.size() < this.minSuppRelative) continue;
                int[] newItemset = new int[itemset1.size() + 1];
                System.arraycopy(itemset1.itemset, 0, newItemset, 0, itemset1.size());
                newItemset[itemset1.size()] = itemset2.getItems()[itemset2.size() - 1];
                Itemset candidate = new Itemset(newItemset);
                candidate.setTIDs(list);
                nextLevel.add(candidate);
            }
        }
        if (level > 2) {
            for (i = 0; i < levelK_1.size(); ++i) {
                for (int j = i + 1; j < levelK_1.size(); ++j) {
                    Itemset candidate1 = levelK_1.get(i);
                    Itemset candidate2 = levelK_1.get(j);
                    int[] arr$ = candidate1.getItems();
                    int len$ = arr$.length;
                    block6: for (int i$ = 0; i$ < len$; ++i$) {
                        Integer a = arr$[i$];
                        if (candidate2.contains(a)) continue;
                        Integer b = null;
                        int[] arr$2 = candidate2.getItems();
                        int len$2 = arr$2.length;
                        for (int i$2 = 0; i$2 < len$2; ++i$2) {
                            Integer itemM = arr$2[i$2];
                            if (candidate1.contains(itemM)) continue;
                            if (b != null) continue block6;
                            b = itemM;
                        }
                        this.testIndirectRule(candidate1, a, b);
                    }
                }
            }
        }
        return nextLevel;
    }

    private void testIndirectRule(Itemset itemset, Integer a, Integer b) throws IOException {
        Set<Integer> tidsA = this.mapItemTIDS.get(a);
        Set<Integer> tidsB = this.mapItemTIDS.get(b);
        int supportAB = 0;
        for (Integer tidFromA : tidsA) {
            if (!tidsB.contains(tidFromA)) continue;
            ++supportAB;
        }
        if ((double)supportAB < this.tsRelative) {
            int supAY = 0;
            block1: for (Integer tidA : tidsA) {
                int[] arr$ = itemset.getItems();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Integer item = arr$[i$];
                    if (!item.equals(a) && !item.equals(b) && !this.mapItemTIDS.get(item).contains(tidA)) continue block1;
                }
                ++supAY;
            }
            double confAY = (double)supAY / (double)tidsA.size();
            if (confAY >= this.minconf) {
                int supBY = 0;
                block3: for (Integer tidB : tidsB) {
                    int[] arr$ = itemset.getItems();
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        Integer item = arr$[i$];
                        if (!item.equals(a) && !item.equals(b) && !this.mapItemTIDS.get(item).contains(tidB)) continue block3;
                    }
                    ++supBY;
                }
                double confBY = (double)supBY / (double)tidsB.size();
                if (confBY >= this.minconf) {
                    this.saveRule(a, b, itemset, confAY, confBY, supAY, supBY);
                }
            }
        }
    }

    private void saveRule(Integer a, Integer b, Itemset itemset, double confAY, double confBY, int supAY, int supBY) throws IOException {
        ++this.ruleCount;
        StringBuffer buffer = new StringBuffer();
        buffer.append("(a=");
        buffer.append(a);
        buffer.append(" b=");
        buffer.append(b);
        buffer.append(" | mediator=");
        for (int i = 0; i < itemset.size(); ++i) {
            if (itemset.get(i).equals(a) || itemset.get(i).equals(b)) continue;
            buffer.append(itemset.get(i));
            buffer.append(" ");
        }
        buffer.append(")");
        buffer.append(" #sup(a,mediator)= ");
        buffer.append(supAY);
        buffer.append(" #sup(b,mediator)= ");
        buffer.append(supBY);
        buffer.append(" #conf(a,mediator)= ");
        buffer.append(confAY);
        buffer.append(" #conf(b,mediator)= ");
        buffer.append(confBY);
        this.writer.write(buffer.toString());
        this.writer.newLine();
    }

    public void printStats() {
        System.out.println("=============  INDIRECT RULES GENERATION - STATS =============");
        System.out.println(" Transactions count from database : " + this.tidcount);
        System.out.println(" Indirect rule count : " + this.ruleCount);
        System.out.println(" Total time ~ " + (this.endTimeStamp - this.startTimestamp) + " ms");
        System.out.println("===================================================");
    }
}

