/*
 * Decompiled with CFR 0.152.
 */
package org.joone.util;

import org.joone.engine.Monitor;
import org.joone.util.MonitorPlugin;

public class LinearAnnealing
extends MonitorPlugin {
    private double learningRateInitial;
    private double learningRateFinal;
    private double momentumInitial;
    private double momentumFinal;
    private static final long serialVersionUID = -3786770944656325519L;

    public double getLearningRateFinal() {
        return this.learningRateFinal;
    }

    public double getLearningRateInitial() {
        return this.learningRateInitial;
    }

    public double getMomentumFinal() {
        return this.momentumFinal;
    }

    public double getMomentumInitial() {
        return this.momentumInitial;
    }

    public void setLearningRateFinal(double newLearningRateFinal) {
        this.learningRateFinal = newLearningRateFinal;
    }

    public void setLearningRateInitial(double newLearningRateInitial) {
        this.learningRateInitial = newLearningRateInitial;
    }

    public void setMomentumFinal(double newMomentumFinal) {
        this.momentumFinal = newMomentumFinal;
    }

    public void setMomentumInitial(double newMomentumInitial) {
        this.momentumInitial = newMomentumInitial;
    }

    @Override
    protected void manageCycle(Monitor mon) {
        double stepLR = (this.getLearningRateInitial() - this.getLearningRateFinal()) / (double)mon.getTotCicles();
        double stepMom = (this.getMomentumInitial() - this.getMomentumFinal()) / (double)mon.getTotCicles();
        int currCicle = mon.getTotCicles() - mon.getCurrentCicle();
        mon.setLearningRate(this.getLearningRateInitial() - stepLR * (double)currCicle);
        mon.setMomentum(this.getMomentumInitial() - stepMom * (double)currCicle);
    }

    @Override
    protected void manageStop(Monitor mon) {
    }

    @Override
    protected void manageStart(Monitor mon) {
    }

    @Override
    protected void manageError(Monitor mon) {
    }

    @Override
    protected void manageStopError(Monitor mon, String msgErr) {
    }
}

