/*
 * Decompiled with CFR 0.152.
 */
package org.joone.util;

import java.util.TreeSet;
import org.joone.engine.Pattern;
import org.joone.io.InputConnector;
import org.joone.io.InputSwitchSynapse;
import org.joone.io.StreamInputSynapse;
import org.joone.net.NetCheck;

public class LearningSwitch
extends InputSwitchSynapse {
    private StreamInputSynapse trainingSet;
    private StreamInputSynapse validationSet;
    private boolean validation = false;
    private static final long serialVersionUID = -2339515807277374407L;
    private int validationPatterns;
    private int trainingPatterns;

    public synchronized boolean addTrainingSet(StreamInputSynapse tSet) {
        if (this.trainingSet != null) {
            return false;
        }
        if (super.addInputSynapse(tSet)) {
            this.trainingSet = tSet;
            super.setDefaultSynapse(this.trainingSet);
            super.reset();
            this.validation = false;
            return true;
        }
        return false;
    }

    public synchronized boolean addValidationSet(StreamInputSynapse vSet) {
        if (this.validationSet != null) {
            return false;
        }
        if (super.addInputSynapse(vSet)) {
            this.validationSet = vSet;
            return true;
        }
        return false;
    }

    public synchronized void removeTrainingSet() {
        if (this.trainingSet != null) {
            super.removeInputSynapse(this.trainingSet.getName());
            this.trainingSet = null;
        }
    }

    public synchronized void removeValidationSet() {
        if (this.validationSet != null) {
            super.removeInputSynapse(this.validationSet.getName());
            this.validationSet = null;
        }
    }

    @Override
    public Pattern fwdGet() {
        if (this.getMonitor().isValidation() && !this.getMonitor().isTrainingDataForValidation()) {
            super.setActiveSynapse(this.validationSet);
        } else {
            super.setActiveSynapse(this.trainingSet);
        }
        return super.fwdGet();
    }

    @Override
    public Pattern fwdGet(InputConnector conn) {
        if (this.getMonitor().isValidation() && !this.getMonitor().isTrainingDataForValidation()) {
            super.setActiveSynapse(this.validationSet);
        } else {
            super.setActiveSynapse(this.trainingSet);
        }
        return super.fwdGet(conn);
    }

    @Override
    public TreeSet check() {
        TreeSet checks = super.check();
        if (this.trainingSet == null) {
            checks.add(new NetCheck(0, "Training set parameter not set", this));
        }
        if (this.validationSet == null) {
            checks.add(new NetCheck(0, "Validation set parameter not set", this));
        }
        return checks;
    }

    public StreamInputSynapse getTrainingSet() {
        return this.trainingSet;
    }

    public void setTrainingSet(StreamInputSynapse trainingSet) {
        this.trainingSet = trainingSet;
    }

    public StreamInputSynapse getValidationSet() {
        return this.validationSet;
    }

    public void setValidationSet(StreamInputSynapse validationSet) {
        this.validationSet = validationSet;
    }
}

