/*
 * Decompiled with CFR 0.152.
 */
package org.joone.samples.engine.xor;

import java.util.Vector;
import org.joone.engine.FullSynapse;
import org.joone.engine.LinearLayer;
import org.joone.engine.Monitor;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;
import org.joone.engine.Pattern;
import org.joone.engine.SigmoidLayer;
import org.joone.engine.learning.TeachingSynapse;
import org.joone.io.MemoryInputSynapse;
import org.joone.io.MemoryOutputSynapse;
import org.joone.net.NeuralNet;

public class XOR_using_NeuralNet_RPROP
implements NeuralNetListener {
    private NeuralNet nnet = null;
    private MemoryInputSynapse inputSynapse;
    private MemoryInputSynapse desiredOutputSynapse;
    private MemoryOutputSynapse outputSynapse;
    private double[][] inputArray = new double[][]{{0.0, 0.0}, {0.0, 1.0}, {1.0, 0.0}, {1.0, 1.0}};
    private double[][] desiredOutputArray = new double[][]{{0.0}, {1.0}, {1.0}, {0.0}};

    public static void main(String[] args) {
        XOR_using_NeuralNet_RPROP xor = new XOR_using_NeuralNet_RPROP();
        xor.initNeuralNet();
        xor.train();
    }

    public void train() {
        this.inputSynapse.setInputArray(this.inputArray);
        this.inputSynapse.setAdvancedColumnSelector("1,2");
        this.desiredOutputSynapse.setInputArray(this.desiredOutputArray);
        this.desiredOutputSynapse.setAdvancedColumnSelector("1");
        Monitor monitor = this.nnet.getMonitor();
        monitor.setLearningRate(1.0);
        monitor.setTrainingPatterns(this.inputArray.length);
        monitor.setTotCicles(500);
        monitor.addLearner(0, "org.joone.engine.RpropLearner");
        monitor.setBatchSize(monitor.getTrainingPatterns());
        monitor.setLearningMode(0);
        monitor.setLearning(true);
        this.nnet.addNeuralNetListener(this);
        this.nnet.go();
    }

    protected void initNeuralNet() {
        LinearLayer input = new LinearLayer();
        SigmoidLayer hidden = new SigmoidLayer();
        SigmoidLayer output = new SigmoidLayer();
        input.setRows(2);
        hidden.setRows(3);
        output.setRows(1);
        FullSynapse synapse_IH = new FullSynapse();
        FullSynapse synapse_HO = new FullSynapse();
        input.addOutputSynapse(synapse_IH);
        hidden.addInputSynapse(synapse_IH);
        hidden.addOutputSynapse(synapse_HO);
        output.addInputSynapse(synapse_HO);
        this.inputSynapse = new MemoryInputSynapse();
        input.addInputSynapse(this.inputSynapse);
        this.outputSynapse = new MemoryOutputSynapse();
        output.addOutputSynapse(this.outputSynapse);
        this.desiredOutputSynapse = new MemoryInputSynapse();
        TeachingSynapse trainer = new TeachingSynapse();
        trainer.setDesired(this.desiredOutputSynapse);
        this.nnet = new NeuralNet();
        this.nnet.addLayer(input, 0);
        this.nnet.addLayer(hidden, 1);
        this.nnet.addLayer(output, 2);
        this.nnet.setTeacher(trainer);
        output.addOutputSynapse(trainer);
    }

    @Override
    public void cicleTerminated(NeuralNetEvent e) {
    }

    @Override
    public void errorChanged(NeuralNetEvent e) {
        Monitor mon = (Monitor)e.getSource();
        if (mon.getCurrentCicle() % 100 == 0) {
            System.out.println("Epoch: " + (mon.getTotCicles() - mon.getCurrentCicle()) + " RMSE:" + mon.getGlobalError());
        }
    }

    @Override
    public void netStarted(NeuralNetEvent e) {
    }

    @Override
    public void netStopped(NeuralNetEvent e) {
        Monitor mon = (Monitor)e.getSource();
        Vector patts = this.outputSynapse.getAllPatterns();
        Pattern pattern = (Pattern)patts.elementAt(patts.size() - 1);
        System.out.println("Output Pattern = " + pattern.getArray()[0] + " Error: " + mon.getGlobalError());
    }

    @Override
    public void netStoppedError(NeuralNetEvent e, String error) {
    }
}

