/*
 * Decompiled with CFR 0.152.
 */
package org.joone.samples.engine.xor;

import java.io.File;
import org.joone.engine.FullSynapse;
import org.joone.engine.LinearLayer;
import org.joone.engine.Monitor;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;
import org.joone.engine.SigmoidLayer;
import org.joone.engine.learning.TeachingSynapse;
import org.joone.io.FileInputSynapse;
import org.joone.io.FileOutputSynapse;
import org.joone.net.NeuralNet;

public class XOR
implements NeuralNetListener {
    private static String inputData = "org/joone/samples/engine/xor/xor.txt";
    private static String outputFile = "/tmp/xorout.txt";

    public static void main(String[] args) {
        XOR xor = new XOR();
        xor.Go(inputData, outputFile);
    }

    public void Go(String inputFile, String outputFile) {
        LinearLayer input = new LinearLayer();
        SigmoidLayer hidden = new SigmoidLayer();
        SigmoidLayer output = new SigmoidLayer();
        input.setLayerName("input");
        hidden.setLayerName("hidden");
        output.setLayerName("output");
        input.setRows(2);
        hidden.setRows(3);
        output.setRows(1);
        FullSynapse synapse_IH = new FullSynapse();
        FullSynapse synapse_HO = new FullSynapse();
        synapse_IH.setName("IH");
        synapse_HO.setName("HO");
        input.addOutputSynapse(synapse_IH);
        hidden.addInputSynapse(synapse_IH);
        hidden.addOutputSynapse(synapse_HO);
        output.addInputSynapse(synapse_HO);
        FileInputSynapse inputStream = new FileInputSynapse();
        inputStream.setAdvancedColumnSelector("1,2");
        inputStream.setInputFile(new File(inputFile));
        input.addInputSynapse(inputStream);
        TeachingSynapse trainer = new TeachingSynapse();
        FileInputSynapse samples = new FileInputSynapse();
        samples.setInputFile(new File(inputFile));
        samples.setAdvancedColumnSelector("3");
        trainer.setDesired(samples);
        FileOutputSynapse error = new FileOutputSynapse();
        error.setFileName(outputFile);
        trainer.addResultSynapse(error);
        output.addOutputSynapse(trainer);
        NeuralNet nnet = new NeuralNet();
        nnet.addLayer(input, 0);
        nnet.addLayer(hidden, 1);
        nnet.addLayer(output, 2);
        nnet.setTeacher(trainer);
        Monitor monitor = nnet.getMonitor();
        monitor.setLearningRate(0.8);
        monitor.setMomentum(0.3);
        monitor.addNeuralNetListener(this);
        monitor.setTrainingPatterns(4);
        monitor.setTotCicles(2000);
        monitor.setLearning(true);
        nnet.go();
    }

    @Override
    public void netStopped(NeuralNetEvent e) {
        System.out.println("Training finished");
    }

    @Override
    public void cicleTerminated(NeuralNetEvent e) {
    }

    @Override
    public void netStarted(NeuralNetEvent e) {
        System.out.println("Training...");
    }

    @Override
    public void errorChanged(NeuralNetEvent e) {
        Monitor mon = (Monitor)e.getSource();
        if (mon.getCurrentCicle() % 200 == 0) {
            System.out.println(mon.getCurrentCicle() + " epochs remaining - RMSE = " + mon.getGlobalError());
        }
    }

    @Override
    public void netStoppedError(NeuralNetEvent e, String error) {
    }
}

