/*
 * Decompiled with CFR 0.152.
 */
package org.joone.samples.engine.validation;

import java.io.File;
import org.joone.engine.FullSynapse;
import org.joone.engine.Layer;
import org.joone.engine.LinearLayer;
import org.joone.engine.Monitor;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;
import org.joone.engine.SigmoidLayer;
import org.joone.engine.Synapse;
import org.joone.engine.learning.TeachingSynapse;
import org.joone.io.FileInputSynapse;
import org.joone.io.StreamInputSynapse;
import org.joone.net.NeuralNet;
import org.joone.net.NeuralNetValidator;
import org.joone.net.NeuralValidationEvent;
import org.joone.net.NeuralValidationListener;
import org.joone.util.LearningSwitch;
import org.joone.util.NormalizerPlugIn;

public class SimpleValidationSample
implements NeuralNetListener,
NeuralValidationListener {
    NeuralNet net;
    long startms;
    private static String filePath = "org/joone/samples/engine/validation";

    public static void main(String[] args) {
        SimpleValidationSample sampleNet = new SimpleValidationSample();
        sampleNet.initialize(filePath);
        sampleNet.start();
    }

    private void initialize(String path) {
        LinearLayer ILayer = new LinearLayer();
        SigmoidLayer HLayer = new SigmoidLayer();
        SigmoidLayer OLayer = new SigmoidLayer();
        ILayer.setRows(13);
        HLayer.setRows(4);
        OLayer.setRows(1);
        FullSynapse synIH = new FullSynapse();
        FullSynapse synHO = new FullSynapse();
        this.connect(ILayer, synIH, HLayer);
        this.connect(HLayer, synHO, OLayer);
        FileInputSynapse ITdata = this.createInput(path + "/wine.txt", 1, 2, 14);
        FileInputSynapse IVdata = this.createInput(path + "/wine.txt", 131, 2, 14);
        FileInputSynapse DTdata = this.createInput(path + "/wine.txt", 1, 1, 1);
        FileInputSynapse DVdata = this.createInput(path + "/wine.txt", 131, 1, 1);
        LearningSwitch Ilsw = this.createSwitch(ITdata, IVdata);
        ILayer.addInputSynapse(Ilsw);
        LearningSwitch Dlsw = this.createSwitch(DTdata, DVdata);
        TeachingSynapse ts = new TeachingSynapse();
        ts.setDesired(Dlsw);
        OLayer.addOutputSynapse(ts);
        this.net = new NeuralNet();
        this.net.addLayer(ILayer, 0);
        this.net.addLayer(HLayer, 1);
        this.net.addLayer(OLayer, 2);
        this.net.setTeacher(ts);
        Monitor mon = this.net.getMonitor();
        mon.setLearningRate(0.4);
        mon.setMomentum(0.5);
        mon.setTrainingPatterns(130);
        mon.setValidationPatterns(48);
        mon.setTotCicles(1000);
        mon.setLearning(true);
    }

    private FileInputSynapse createInput(String name, int firstRow, int firstCol, int lastCol) {
        FileInputSynapse input = new FileInputSynapse();
        input.setInputFile(new File(name));
        input.setFirstRow(firstRow);
        if (firstCol != lastCol) {
            input.setAdvancedColumnSelector(firstCol + "-" + lastCol);
        } else {
            input.setAdvancedColumnSelector(Integer.toString(firstCol));
        }
        NormalizerPlugIn norm = new NormalizerPlugIn();
        if (firstCol != lastCol) {
            norm.setAdvancedSerieSelector("1-" + Integer.toString(lastCol - firstCol + 1));
        } else {
            norm.setAdvancedSerieSelector("1");
        }
        norm.setMin(0.1);
        norm.setMax(0.9);
        input.addPlugIn(norm);
        return input;
    }

    private void connect(Layer ly1, Synapse syn, Layer ly2) {
        ly1.addOutputSynapse(syn);
        ly2.addInputSynapse(syn);
    }

    private LearningSwitch createSwitch(StreamInputSynapse IT, StreamInputSynapse IV) {
        LearningSwitch lsw = new LearningSwitch();
        lsw.addTrainingSet(IT);
        lsw.addValidationSet(IV);
        return lsw;
    }

    private void start() {
        this.net.getMonitor().addNeuralNetListener(this);
        this.startms = System.currentTimeMillis();
        this.net.go();
    }

    @Override
    public void netValidated(NeuralValidationEvent event) {
        NeuralNet NN = (NeuralNet)event.getSource();
        System.out.println("    Validation Error: " + NN.getMonitor().getGlobalError());
    }

    @Override
    public void cicleTerminated(NeuralNetEvent e) {
        int cycle = this.net.getMonitor().getTotCicles() - this.net.getMonitor().getCurrentCicle() + 1;
        if (cycle % 200 == 0) {
            System.out.println("Cycle #" + cycle);
            System.out.println("    Training Error:   " + this.net.getMonitor().getGlobalError());
            this.net.getMonitor().setExporting(true);
            NeuralNet newNet = this.net.cloneNet();
            this.net.getMonitor().setExporting(false);
            newNet.removeAllListeners();
            NeuralNetValidator nnv = new NeuralNetValidator(newNet);
            nnv.addValidationListener(this);
            nnv.start();
        }
    }

    @Override
    public void errorChanged(NeuralNetEvent e) {
    }

    @Override
    public void netStarted(NeuralNetEvent e) {
    }

    @Override
    public void netStopped(NeuralNetEvent e) {
        System.out.println("Stopped after " + (System.currentTimeMillis() - this.startms) + " ms");
    }

    @Override
    public void netStoppedError(NeuralNetEvent e, String error) {
    }
}

