/*
 * Decompiled with CFR 0.152.
 */
package org.joone.samples.engine.parity;

import java.io.Serializable;
import java.util.Vector;
import org.joone.engine.FullSynapse;
import org.joone.engine.GaussLayer;
import org.joone.engine.LinearLayer;
import org.joone.engine.Monitor;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;
import org.joone.engine.Pattern;
import org.joone.engine.SigmoidLayer;
import org.joone.engine.SineLayer;
import org.joone.engine.learning.TeachingSynapse;
import org.joone.engine.listeners.DeltaBasedConvergenceObserver;
import org.joone.io.MemoryInputSynapse;
import org.joone.io.MemoryOutputSynapse;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NeuralNet;
import org.joone.structure.Nakayama;

public class Parity_Structure_Nakayama
implements NeuralNetListener,
Serializable {
    private static final ILogger log = LoggerFactory.getLogger(Nakayama.class);
    private NeuralNet nnet = null;
    private MemoryInputSynapse inputSynapse;
    private MemoryInputSynapse desiredOutputSynapse;
    private MemoryOutputSynapse outputSynapse;
    private Nakayama nakayama;
    private double[][] inputArray = new double[][]{{0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 1.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 1.0, 1.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 1.0}, {0.0, 1.0, 1.0, 0.0}, {0.0, 1.0, 1.0, 1.0}, {1.0, 0.0, 0.0, 0.0}, {1.0, 0.0, 0.0, 1.0}, {1.0, 0.0, 1.0, 0.0}, {1.0, 0.0, 1.0, 1.0}, {1.0, 1.0, 0.0, 0.0}, {1.0, 1.0, 0.0, 1.0}, {1.0, 1.0, 1.0, 0.0}, {1.0, 1.0, 1.0, 1.0}};
    private double[][] desiredOutputArray = new double[][]{{0.0}, {1.0}, {1.0}, {0.0}, {1.0}, {0.0}, {0.0}, {1.0}, {1.0}, {0.0}, {0.0}, {1.0}, {0.0}, {1.0}, {1.0}, {0.0}};

    public static void main(String[] args) {
        Parity_Structure_Nakayama parity = new Parity_Structure_Nakayama();
        parity.initNeuralNet();
        parity.train();
    }

    public void train() {
        this.inputSynapse.setInputArray(this.inputArray);
        this.inputSynapse.setAdvancedColumnSelector("1-4");
        this.desiredOutputSynapse.setInputArray(this.desiredOutputArray);
        this.desiredOutputSynapse.setAdvancedColumnSelector("1");
        Monitor monitor = this.nnet.getMonitor();
        monitor.setUseRMSE(false);
        monitor.setLearningRate(0.5);
        monitor.setMomentum(0.3);
        monitor.setTrainingPatterns(this.inputArray.length);
        monitor.setTotCicles(5000);
        monitor.setLearning(true);
        monitor.addLearner(0, "org.joone.engine.RpropLearner");
        monitor.addLearner(1, "org.joone.engine.BatchLearner");
        monitor.addLearner(2, "org.joone.engine.BasicLearner");
        monitor.setBatchSize(this.inputArray.length);
        monitor.setLearningMode(2);
        monitor.setSingleThreadMode(false);
        this.nnet.addNeuralNetListener(this);
        this.nnet.go();
    }

    private void test() {
        this.nnet.getMonitor().setTotCicles(1);
        this.nnet.getMonitor().setLearning(false);
        this.nnet.getMonitor().setSingleThreadMode(false);
        this.outputSynapse.setEnabled(true);
        this.nnet.removeAllListeners();
        this.nnet.go(true);
        Vector patts = this.outputSynapse.getAllPatterns();
        System.out.println("\nResults:");
        for (int i = patts.size(); i > 0; --i) {
            Pattern pattern = (Pattern)patts.elementAt(patts.size() - i);
            System.out.println("Output Pattern #" + (patts.size() - i) + " = " + pattern.getArray()[0]);
        }
        System.out.println("Final RMSE: " + this.nnet.getMonitor().getGlobalError());
    }

    protected void initNeuralNet() {
        LinearLayer input = new LinearLayer();
        SigmoidLayer hiddenSigmoid = new SigmoidLayer();
        SineLayer hiddenSine = new SineLayer();
        GaussLayer hiddenGauss = new GaussLayer();
        SigmoidLayer output = new SigmoidLayer();
        input.setRows(4);
        hiddenSigmoid.setRows(8);
        hiddenSine.setRows(8);
        hiddenGauss.setRows(8);
        output.setRows(1);
        FullSynapse synapse_IHSIGMOID = new FullSynapse();
        FullSynapse synapse_IHSINE = new FullSynapse();
        FullSynapse synapse_IHGAUSS = new FullSynapse();
        FullSynapse synapse_HSIGMOIDO = new FullSynapse();
        FullSynapse synapse_HSINEO = new FullSynapse();
        FullSynapse synapse_HGAUSSO = new FullSynapse();
        input.addOutputSynapse(synapse_IHSIGMOID);
        input.addOutputSynapse(synapse_IHSINE);
        input.addOutputSynapse(synapse_IHGAUSS);
        hiddenSigmoid.addInputSynapse(synapse_IHSIGMOID);
        hiddenSine.addInputSynapse(synapse_IHSINE);
        hiddenGauss.addInputSynapse(synapse_IHGAUSS);
        hiddenSigmoid.addOutputSynapse(synapse_HSIGMOIDO);
        hiddenSine.addOutputSynapse(synapse_HSINEO);
        hiddenGauss.addOutputSynapse(synapse_HGAUSSO);
        output.addInputSynapse(synapse_HSIGMOIDO);
        output.addInputSynapse(synapse_HSINEO);
        output.addInputSynapse(synapse_HGAUSSO);
        this.inputSynapse = new MemoryInputSynapse();
        input.addInputSynapse(this.inputSynapse);
        this.outputSynapse = new MemoryOutputSynapse();
        output.addOutputSynapse(this.outputSynapse);
        this.outputSynapse.setEnabled(false);
        this.desiredOutputSynapse = new MemoryInputSynapse();
        TeachingSynapse trainer = new TeachingSynapse();
        trainer.setDesired(this.desiredOutputSynapse);
        this.nnet = new NeuralNet();
        this.nnet.addLayer(input, 0);
        this.nnet.addLayer(hiddenSigmoid, 1);
        this.nnet.addLayer(hiddenSine, 1);
        this.nnet.addLayer(hiddenGauss, 1);
        this.nnet.addLayer(output, 2);
        this.nnet.setTeacher(trainer);
        output.addOutputSynapse(trainer);
        this.nakayama = new Nakayama(this.nnet);
        this.nakayama.addLayer(hiddenSigmoid);
        this.nakayama.addLayer(hiddenSine);
        this.nakayama.addLayer(hiddenGauss);
        DeltaBasedConvergenceObserver myObserver = new DeltaBasedConvergenceObserver();
        myObserver.setSize(5.0E-4);
        myObserver.setNeuralNet(this.nnet);
        myObserver.addConvergenceListener(this.nakayama);
        this.nnet.addNeuralNetListener(myObserver);
    }

    @Override
    public void cicleTerminated(NeuralNetEvent e) {
    }

    @Override
    public void errorChanged(NeuralNetEvent e) {
        Monitor mon = (Monitor)e.getSource();
        int c = mon.getTotCicles() - mon.getCurrentCicle();
        if (c % 100 == 0) {
            System.out.println("Cycle: " + c + " (R)MSE:" + mon.getGlobalError());
        }
    }

    @Override
    public void netStarted(NeuralNetEvent e) {
    }

    @Override
    public void netStopped(NeuralNetEvent e) {
        this.test();
    }

    @Override
    public void netStoppedError(NeuralNetEvent e, String error) {
    }
}

