/*
 * Decompiled with CFR 0.152.
 */
package org.joone.net;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NeuralNet;

public class NeuralNetLoader {
    private static final ILogger log = LoggerFactory.getLogger(NeuralNetLoader.class);
    NeuralNet nnet;

    public NeuralNetLoader(String netName) {
        try {
            this.nnet = this.readNeuralNet(netName);
        }
        catch (Exception e) {
            log.error("Cannot create the NeuralNet with the following name : \"" + netName + "\"", e);
        }
    }

    public NeuralNet getNeuralNet() {
        return this.nnet;
    }

    private NeuralNet readNeuralNet(String NeuralNet2) throws IOException, ClassNotFoundException {
        if (NeuralNet2 == null) {
            return null;
        }
        if (NeuralNet2.equals(new String(""))) {
            return null;
        }
        File NNFile = new File(NeuralNet2);
        FileInputStream fin = new FileInputStream(NNFile);
        ObjectInputStream oin = new ObjectInputStream(fin);
        NeuralNet newNeuralNet = (NeuralNet)oin.readObject();
        oin.close();
        fin.close();
        return newNeuralNet;
    }
}

