/*
 * Decompiled with CFR 0.152.
 */
package org.joone.inspection.implementations;

import org.joone.engine.Matrix;
import org.joone.inspection.Inspection;

public class BiasInspection
implements Inspection {
    private Matrix bias;

    public BiasInspection(Matrix biasArg) {
        this.bias = biasArg;
    }

    @Override
    public Object[][] getComponent() {
        if (this.bias == null) {
            return null;
        }
        double[][] values = this.bias.getValue();
        if (values.length > 0 && values[0].length > 0) {
            Object[][] bigValues = new Object[values.length][values[0].length];
            for (int i = 0; i < values[0].length; ++i) {
                for (int j = 0; j < values.length; ++j) {
                    bigValues[j][i] = new Double(values[j][i]);
                }
            }
            return bigValues;
        }
        return null;
    }

    @Override
    public Object[] getNames() {
        if (this.bias == null) {
            return null;
        }
        double[][] values = this.bias.getValue();
        if (values.length > 0 && values[0].length > 0) {
            Object[] names = new String[values[0].length];
            for (int i = 0; i < values[0].length; ++i) {
                names[i] = "Column " + i;
            }
            return names;
        }
        return null;
    }

    @Override
    public String getTitle() {
        return "Bias";
    }

    @Override
    public boolean rowNumbers() {
        return false;
    }

    @Override
    public void setComponent(Object[][] newValues) {
        double[][] values = this.bias.getValue();
        for (int x = 0; x < values.length && x < newValues.length; ++x) {
            for (int y = 0; y < values[0].length && y < newValues[0].length; ++y) {
                values[x][y] = (Double)newValues[x][y];
            }
        }
    }
}

