/*
 * Decompiled with CFR 0.152.
 */
package org.joone.helpers.structure;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import org.joone.engine.Monitor;
import org.joone.engine.learning.TeachingSynapse;
import org.joone.helpers.factory.JooneTools;
import org.joone.io.FileInputSynapse;
import org.joone.io.StreamInputSynapse;
import org.joone.net.NeuralNet;
import org.joone.util.NormalizerPlugIn;

public class NeuralNetFactory {
    public static final int CLASSIFICATION = 1;
    public static final int ONEOFC_CLASSIF = 2;
    public static final int APPROXIMIMATION = 3;
    public static final int PREDICTION = 4;
    public static final int CLUSTERING = 5;
    private int type;
    private String inputFileName;
    private String inputCols;
    private boolean skipFirstInputRow;
    private String desiredFileName;
    private String desiredCols;
    private boolean skipFirstDesiredRow;
    private int taps;
    private int predictLength;
    private int mapWidth;
    private int mapHeight;

    public NeuralNet getNeuralNetwork() {
        NeuralNet nnet = null;
        switch (this.getType()) {
            case 1: 
            case 2: 
            case 3: {
                nnet = this.createFFNN();
                break;
            }
            case 4: {
                nnet = this.createTimeSeries();
                break;
            }
            case 5: {
                nnet = this.createKohonen();
            }
        }
        this.create_IO(nnet);
        return nnet;
    }

    protected NeuralNet createFFNN() {
        int inputRows = this.getNumOfColumns(this.inputCols);
        int outputRows = this.getNumOfColumns(this.desiredCols);
        int[] nodes = new int[]{inputRows, inputRows, outputRows};
        int outputType = 1;
        switch (this.getType()) {
            case 1: {
                outputType = 2;
                break;
            }
            case 2: {
                outputType = 3;
                break;
            }
            case 3: {
                outputType = 1;
            }
        }
        NeuralNet nnet = JooneTools.create_standard(nodes, outputType);
        Monitor mon = nnet.getMonitor();
        mon.setTotCicles(5000);
        mon.setTrainingPatterns(this.getNumOfRows(this.inputFileName, this.skipFirstInputRow));
        mon.setLearning(true);
        return nnet;
    }

    protected NeuralNet createKohonen() {
        int inputRows = this.getNumOfColumns(this.inputCols);
        int outputRows = 10;
        int[] nodes = new int[]{inputRows, this.getMapWidth(), this.getMapHeight()};
        int outputType = 4;
        NeuralNet nnet = JooneTools.create_unsupervised(nodes, outputType);
        Monitor mon = nnet.getMonitor();
        mon.setTotCicles(5000);
        mon.setTrainingPatterns(this.getNumOfRows(this.inputFileName, this.skipFirstInputRow));
        mon.setLearning(true);
        return nnet;
    }

    protected NeuralNet createTimeSeries() {
        int inputRows = this.getNumOfColumns(this.inputCols);
        int outputRows = this.getNumOfColumns(this.desiredCols);
        int[] nodes = new int[]{inputRows, this.getTaps(), outputRows};
        int outputType = 1;
        NeuralNet nnet = JooneTools.create_timeDelay(nodes, this.getTaps() - 1, outputType);
        Monitor mon = nnet.getMonitor();
        mon.setTotCicles(5000);
        mon.setTrainingPatterns(this.getNumOfRows(this.inputFileName, this.skipFirstInputRow) - this.getPredictionLength());
        mon.setLearning(true);
        mon.setPreLearning(this.getTaps());
        return nnet;
    }

    protected void create_IO(NeuralNet nnet) {
        StreamInputSynapse inputData = this.createInput(this.inputFileName, this.inputCols, this.skipFirstInputRow ? 2 : 1);
        nnet.getInputLayer().addInputSynapse(inputData);
        if (this.getType() != 5) {
            StreamInputSynapse targetData = this.createInput(this.desiredFileName, this.desiredCols, this.skipFirstDesiredRow ? 2 : 1);
            if (this.getPredictionLength() > 0) {
                targetData.setFirstRow(inputData.getFirstRow() + this.getPredictionLength());
            }
            TeachingSynapse teacher = new TeachingSynapse();
            teacher.setName("Teacher");
            teacher.setDesired(targetData);
            nnet.getOutputLayer().addOutputSynapse(teacher);
            nnet.setTeacher(teacher);
        }
    }

    protected StreamInputSynapse createInput(String fileName, String columns, int firstRow) {
        FileInputSynapse in = new FileInputSynapse();
        in.setInputFile(new File(fileName));
        in.setAdvancedColumnSelector(columns);
        in.setFirstRow(firstRow);
        NormalizerPlugIn norm = new NormalizerPlugIn();
        int cols = this.getNumOfColumns(columns);
        norm.setAdvancedSerieSelector("1-" + cols);
        in.addPlugIn(norm);
        return in;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getInputFileName() {
        return this.inputFileName;
    }

    public void setInputFileName(String inputFileName) {
        this.inputFileName = inputFileName;
    }

    public String getInputCols() {
        return this.inputCols;
    }

    public void setInputCols(String inputCols) {
        this.inputCols = inputCols;
    }

    public boolean isSkipFirstInputRow() {
        return this.skipFirstInputRow;
    }

    public void setSkipFirstInputRow(boolean skipFirstInputRow) {
        this.skipFirstInputRow = skipFirstInputRow;
    }

    public String getDesiredFileName() {
        return this.desiredFileName;
    }

    public void setDesiredFileName(String desiredFileName) {
        this.desiredFileName = desiredFileName;
    }

    public String getDesiredCols() {
        return this.desiredCols;
    }

    public void setDesiredCols(String desiredCols) {
        this.desiredCols = desiredCols;
    }

    public boolean isSkipFirstDesiredRow() {
        return this.skipFirstDesiredRow;
    }

    public void setSkipFirstDesiredRow(boolean skipFirstDesiredRow) {
        this.skipFirstDesiredRow = skipFirstDesiredRow;
    }

    protected int getNumOfColumns(String columns) {
        int c = 0;
        StringTokenizer tokens = new StringTokenizer(columns, ",");
        int n = tokens.countTokens();
        for (int i = 0; i < n; ++i) {
            String t = tokens.nextToken();
            if (t.indexOf(45) == -1) {
                ++c;
                continue;
            }
            StringTokenizer tt = new StringTokenizer(t, "-");
            int low = Integer.valueOf(tt.nextToken());
            int hig = Integer.valueOf(tt.nextToken());
            c += hig - low + 1;
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getNumOfRows(String fileName, boolean skipFirstLine) {
        int c = 0;
        BufferedReader file = null;
        try {
            file = new BufferedReader(new FileReader(fileName));
            if (skipFirstLine) {
                file.readLine();
            }
            while (file.readLine() != null) {
                ++c;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (IOException iOException) {}
            }
        }
        return c;
    }

    public int getTaps() {
        return this.taps;
    }

    public void setTaps(int taps) {
        this.taps = taps;
    }

    public int getPredictionLength() {
        return this.predictLength;
    }

    public void setPredictionLength(int predictLength) {
        this.predictLength = predictLength;
    }

    public int getMapWidth() {
        return this.mapWidth;
    }

    public void setMapWidth(int mapWidth) {
        this.mapWidth = mapWidth;
    }

    public int getMapHeight() {
        return this.mapHeight;
    }

    public void setMapHeight(int mapHeight) {
        this.mapHeight = mapHeight;
    }
}

