/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine.listeners;

import org.joone.engine.Monitor;
import org.joone.engine.listeners.ConvergenceObserver;

public class ErrorBasedConvergenceObserver
extends ConvergenceObserver {
    private double percentage = -1.0;
    private int cycles = 5;
    private int cycleCounter = 0;
    private double lastError = -1.0;

    public void setPercentage(double aPercentage) {
        this.percentage = aPercentage;
    }

    public double getPercentage() {
        return this.percentage;
    }

    public void setCycles(int aCylces) {
        this.cycles = aCylces;
    }

    public int getCycles() {
        return this.cycles;
    }

    @Override
    protected void manageStop(Monitor mon) {
    }

    @Override
    protected void manageCycle(Monitor mon) {
    }

    @Override
    protected void manageStart(Monitor mon) {
    }

    @Override
    protected void manageError(Monitor mon) {
        if (this.percentage < 0.0 || this.cycles <= 0) {
            return;
        }
        double myCurrentError = mon.getGlobalError();
        if (this.lastError >= 0.0) {
            double myPercentage = (this.lastError - myCurrentError) * 100.0 / this.lastError;
            if (myPercentage <= this.percentage && myPercentage >= 0.0) {
                ++this.cycleCounter;
            } else {
                this.disableCurrentConvergence = false;
                this.cycleCounter = 0;
            }
            if (this.cycleCounter == this.cycles) {
                if (!this.disableCurrentConvergence) {
                    this.fireNetConverged(mon);
                }
                this.cycleCounter = 0;
            }
        }
        this.lastError = myCurrentError;
    }

    @Override
    protected void manageStopError(Monitor mon, String msgErr) {
    }
}

