/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine;

import org.joone.engine.LearnableLayer;
import org.joone.engine.SimpleLayer;
import org.joone.exception.JooneRuntimeException;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;

public class GaussLayer
extends SimpleLayer
implements LearnableLayer {
    private static final ILogger log = LoggerFactory.getLogger(GaussLayer.class);

    public GaussLayer() {
        this.learnable = true;
    }

    public GaussLayer(String aName) {
        this();
        this.setLayerName(aName);
    }

    @Override
    protected void forward(double[] aPattern) throws JooneRuntimeException {
        int myRows = this.getRows();
        int i = 0;
        try {
            for (i = 0; i < myRows; ++i) {
                double myNeuronInput = aPattern[i] + this.getBias().value[i][0];
                this.outs[i] = Math.exp(-myNeuronInput * myNeuronInput);
            }
        }
        catch (Exception aioobe) {
            String msg = "Exception thrown while processing the element " + i + " of the array. Value is : " + aPattern[i] + " Exception thrown is " + aioobe.getClass().getName() + ". Message is " + aioobe.getMessage();
            log.error(msg);
            throw new JooneRuntimeException(msg, aioobe);
        }
    }

    @Override
    public void backward(double[] aPattern) throws JooneRuntimeException {
        super.backward(aPattern);
        int myRows = this.getRows();
        int i = 0;
        for (i = 0; i < myRows; ++i) {
            this.gradientOuts[i] = aPattern[i] * -2.0 * this.inps[i] * this.outs[i];
        }
        this.myLearner.requestBiasUpdate(this.gradientOuts);
    }
}

