/*
 * Decompiled with CFR 0.152.
 */
package org.joone.edit;

import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.standard.ConnectionTool;
import java.util.Hashtable;
import org.joone.edit.LayerConnection;
import org.joone.edit.NeuralNetDrawing;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;

public class SynapseCreationTool
extends ConnectionTool {
    public static final ILogger log = LoggerFactory.getLogger(SynapseCreationTool.class);
    protected Hashtable params = new Hashtable();
    String objType;
    DrawingView view;

    public SynapseCreationTool(DrawingView view, String type) {
        super(view, null);
        this.objType = type;
        this.view = view;
    }

    @Override
    protected ConnectionFigure createConnection() {
        try {
            Class<?> cLayer = Class.forName(this.objType);
            LayerConnection lc = (LayerConnection)cLayer.newInstance();
            lc.setParams(this.params);
            NeuralNetDrawing nnd = (NeuralNetDrawing)this.view.drawing();
            lc.setParam("NeuralNet", nnd.getNeuralNet());
            return lc;
        }
        catch (ClassNotFoundException cnfe) {
            log.warn("ClassNotFoundException exception thrown while ConnectionFigure. Message is : " + cnfe.getMessage(), cnfe);
        }
        catch (InstantiationException ie) {
            log.warn("InstantiationException exception thrown while ConnectionFigure. Message is : " + ie.getMessage(), ie);
        }
        catch (IllegalAccessException iae) {
            log.warn("IllegalAccessException exception thrown while ConnectionFigure. Message is : " + iae.getMessage(), iae);
        }
        return null;
    }

    public Object getParam(Object key) {
        return this.params.get(key);
    }

    public void setParam(Object key, Object newParam) {
        this.params.put(key, newParam);
    }

    public void setParams(Hashtable newParams) {
        this.params = newParams;
    }
}

