/*
 * Decompiled with CFR 0.152.
 */
package org.joone.edit;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;

public class JooneFileChooser
extends JFileChooser {
    private static final ILogger log = LoggerFactory.getLogger(JooneFileChooser.class);
    private String m_dir = System.getProperty("user.home") + System.getProperty("file.separator") + "Joone Edit" + "_DIRECTORY_HISTORY.cfg";
    private FileInputStream m_fis;
    private ObjectInputStream m_ois;
    private Vector m_dirList;
    private final String APPLICATION_NAME = "Joone Edit";
    private HistoryAndPreviewPanel m_historyAndPreviewPanel;
    private JComboBox m_comboBox;
    private TextPreviewer m_previewer;
    private static final long serialVersionUID = 8488231091781173351L;

    public JooneFileChooser(String baseDir) {
        super(baseDir);
        if (new File(this.m_dir).exists()) {
            try {
                this.m_fis = new FileInputStream(this.m_dir);
            }
            catch (FileNotFoundException fnfe) {
                log.warn("File '" + this.m_dir + "' not found. Message is : " + fnfe.getMessage());
            }
            try {
                this.m_ois = new ObjectInputStream(this.m_fis);
            }
            catch (StreamCorruptedException sce) {
                new File(this.m_dir).delete();
                this.m_dirList = new Vector();
            }
            catch (IOException ioe) {
                log.warn("File '" + this.m_dir + "' input/output error. Message is : " + ioe.getMessage());
                this.m_dirList = new Vector();
            }
            try {
                if (this.m_ois != null) {
                    this.m_dirList = (Vector)this.m_ois.readObject();
                    if (this.m_dirList == null) {
                        this.m_dirList = new Vector();
                    }
                } else {
                    this.m_dirList = new Vector();
                }
            }
            catch (OptionalDataException ode) {
                log.warn("File '" + this.m_dir + "' does not contain object.");
                this.m_dirList = new Vector();
            }
            catch (IOException ioe) {
                log.warn("File '" + this.m_dir + "' input/output error. Message is : " + ioe.getMessage());
                this.m_dirList = new Vector();
            }
            catch (ClassNotFoundException cnfe) {
                log.warn("ClassNotFoundException thrown. Message is : " + cnfe.getMessage());
                this.m_dirList = new Vector();
            }
            try {
                if (this.m_ois != null) {
                    this.m_ois.close();
                }
                this.m_fis.close();
            }
            catch (IOException ioe) {
                log.warn("File '" + this.m_dir + "' input/output error. Message is : " + ioe.getMessage());
            }
        } else {
            this.m_dirList = new Vector();
        }
        this.setMultiSelectionEnabled(false);
        this.m_historyAndPreviewPanel = new HistoryAndPreviewPanel();
        this.setAccessory(this.m_historyAndPreviewPanel);
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                File f;
                if (e.getPropertyName().equals("directoryChanged")) {
                    JooneFileChooser.this.m_previewer.clear();
                }
                if (e.getPropertyName().equals("SelectedFileChangedProperty") && (f = (File)e.getNewValue()) != null && f.isFile()) {
                    JooneFileChooser.this.m_previewer.showFileContents(f);
                    JooneFileChooser.this.addDirectory(f);
                }
            }
        });
    }

    public JooneFileChooser() {
        this(".");
    }

    public void saveDirectoryEntries() {
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new FileOutputStream(this.m_dir);
        }
        catch (FileNotFoundException fnfe) {
            log.warn("File '" + this.m_dir + "' not found.", fnfe);
        }
        try {
            oos = new ObjectOutputStream(fos);
            oos.writeObject(this.m_dirList);
            oos.flush();
            oos.close();
            fos.close();
        }
        catch (IOException ioe) {
            log.warn("File '" + this.m_dir + "' input/output error. Message is : " + ioe.getMessage(), ioe);
        }
    }

    private void addDirectory(File p_file) {
        if (p_file == null || p_file.getName().equals("")) {
            return;
        }
        String absolutePath = p_file.getAbsolutePath();
        int posDirSep = absolutePath.lastIndexOf(System.getProperty("file.separator"));
        String d = absolutePath.substring(0, posDirSep);
        this.m_dirList.removeElement(d);
        this.m_dirList.add(0, d);
        this.updateJComboBox();
    }

    private void updateJComboBox() {
        this.m_comboBox.revalidate();
        this.m_comboBox.setSelectedIndex(0);
    }

    public static void main(String[] args) {
        final JFrame f = new JFrame("Joone FileChooser Demo");
        final JooneFileChooser fc = new JooneFileChooser();
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                fc.saveDirectoryEntries();
                f.setVisible(false);
                f.dispose();
                System.exit(0);
            }
        });
        JMenuBar mb = new JMenuBar();
        f.setJMenuBar(mb);
        JMenu m = new JMenu("File");
        m.setMnemonic('F');
        mb.add(m);
        JMenuItem o = new JMenuItem("Open...");
        o.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file;
                fc.setCurrentDirectory(new File("."));
                String filename = e.toString();
                int val = fc.showOpenDialog(f);
                if (val == 0 && (file = fc.getSelectedFile()) != null && !file.getName().equals("")) {
                    filename = file.getName();
                }
            }
        });
        m.add(o);
        f.pack();
        f.setSize(310, 130);
        f.setVisible(true);
    }

    private class TextPreviewer
    extends JComponent {
        private JTextArea m_textArea = new JTextArea();
        private JScrollPane m_scroller = new JScrollPane(this.m_textArea);
        private char[] m_buf = new char[500];
        private static final long serialVersionUID = -1771309681222930860L;

        public TextPreviewer() {
            this.m_textArea.setEditable(false);
            this.setLayout(new BorderLayout());
            this.add((Component)this.m_scroller, "Center");
        }

        public void showFileContents(File p_file) {
            this.m_textArea.setText(this.readFile(p_file));
            this.m_textArea.setCaretPosition(0);
        }

        public void clear() {
            this.m_textArea.setText("");
        }

        private String readFile(File p_file) {
            String str = null;
            FileReader reader = null;
            try {
                reader = new FileReader(p_file);
            }
            catch (FileNotFoundException fnfe) {
                log.warn("File '" + p_file + "' not found.", fnfe);
                return str;
            }
            try {
                int nch = reader.read(this.m_buf, 0, this.m_buf.length);
                if (nch != -1) {
                    str = new String(this.m_buf, 0, nch);
                }
                reader.close();
            }
            catch (IOException ioe) {
                log.warn("File '" + JooneFileChooser.this.m_dir + "' input/output error.", ioe);
            }
            return str;
        }
    }

    private final class HistoryAndPreviewPanel
    extends JPanel {
        private static final long serialVersionUID = 8111982139735281484L;

        public HistoryAndPreviewPanel() {
            this.setPreferredSize(new Dimension(250, 250));
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setLayout(new BorderLayout());
            JooneFileChooser.this.m_comboBox = new JComboBox(JooneFileChooser.this.m_dirList);
            JooneFileChooser.this.m_comboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String dir = (String)JooneFileChooser.this.m_comboBox.getSelectedItem();
                    JooneFileChooser.this.setCurrentDirectory(new File(dir));
                    JLabel label = new JLabel(dir);
                    label.setFont(JooneFileChooser.this.m_comboBox.getFont());
                    if (label.getPreferredSize().width > ((JooneFileChooser)JooneFileChooser.this).m_comboBox.getSize().width) {
                        JooneFileChooser.this.m_comboBox.setToolTipText(dir);
                    } else {
                        JooneFileChooser.this.m_comboBox.setToolTipText(null);
                    }
                }
            });
            this.add((Component)JooneFileChooser.this.m_comboBox, "North");
            JooneFileChooser.this.m_previewer = new TextPreviewer();
            this.add((Component)JooneFileChooser.this.m_previewer, "Center");
        }
    }
}

