/*
 * Decompiled with CFR 0.152.
 */
package org.joone.edit;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.Serializable;
import javax.swing.text.StyleContext;

public class CaseAwareTextDisplay
extends Canvas
implements Serializable {
    public static final int AS_IS = 0;
    public static final int UPPERCASE = 1;
    public static final int LOWERCASE = 2;
    public static final int FIRST_IN_CAPS = 3;
    public static final String TEXT = "text";
    public static final String TOP_MARGIN = "topMargin";
    public static final String LEFT_MARGIN = "leftMargin";
    public static final String FOREGROUND = "foreground";
    public static final String BACKGROUND = "background";
    public static final String TEXT_CASE = "textCase";
    public static final String FONT = "font";
    static final long serialVersionUID = -6141230100503340864L;
    protected String text = "default text";
    protected int topMargin = 4;
    protected int leftMargin = 4;
    protected int textCase = 0;
    protected PropertyChangeSupport propertyListenerSupport;
    protected VetoableChangeSupport vetoListenerSupport;

    public CaseAwareTextDisplay() {
        this.setSize(180, 30);
        this.propertyListenerSupport = new PropertyChangeSupport(this);
        this.vetoListenerSupport = new VetoableChangeSupport(this);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        String oldValue = this.text;
        this.text = text;
        this.firePropertyChange(TEXT, oldValue, this.text);
    }

    public int getTopMargin() {
        return this.topMargin;
    }

    public void setTopMargin(int pixels) {
        int oldValue = this.topMargin;
        this.topMargin = pixels;
        this.firePropertyChange(TOP_MARGIN, new Integer(oldValue), new Integer(this.topMargin));
    }

    public int getLeftMargin() {
        return this.leftMargin;
    }

    public void setLeftMargin(int pixels) {
        int oldValue = this.leftMargin;
        this.leftMargin = pixels;
        this.firePropertyChange(LEFT_MARGIN, new Integer(oldValue), new Integer(this.leftMargin));
    }

    @Override
    public void setForeground(Color newColor) {
        Color oldValue = this.getForeground();
        try {
            this.fireVetoableChange(FOREGROUND, oldValue, newColor);
            super.setForeground(newColor);
            this.firePropertyChange(FOREGROUND, oldValue, newColor);
            this.repaint();
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    @Override
    public void setBackground(Color newColor) {
        Color oldValue = this.getBackground();
        try {
            this.fireVetoableChange(BACKGROUND, oldValue, newColor);
            super.setBackground(newColor);
            this.firePropertyChange(BACKGROUND, oldValue, newColor);
            this.repaint();
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public int getTextCase() {
        return this.textCase;
    }

    public void setTextCase(int textCase) {
        int oldValue = this.textCase;
        this.textCase = textCase;
        this.firePropertyChange(TEXT_CASE, new Integer(oldValue), new Integer(this.textCase));
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        String convertedText = this.getText();
        if (convertedText == null) {
            convertedText = " ";
        }
        switch (this.textCase) {
            case 1: {
                convertedText = convertedText.toUpperCase();
                break;
            }
            case 2: {
                convertedText = convertedText.toLowerCase();
                break;
            }
            case 3: {
                convertedText = convertedText.toLowerCase();
                char[] temp = convertedText.toCharArray();
                int previous = 32;
                for (int i = 0; i < temp.length; ++i) {
                    if (previous == 32) {
                        temp[i] = Character.toUpperCase(temp[i]);
                    }
                    previous = temp[i];
                }
                convertedText = new String(temp);
                break;
            }
        }
        Rectangle r = this.getBounds();
        Font font = this.getFont();
        if (font == null) {
            font = new Font("Dialog", 0, 12);
        }
        FontMetrics fm = StyleContext.getDefaultStyleContext().getFontMetrics(font);
        int x = this.leftMargin;
        int y = this.topMargin + fm.getAscent();
        Color color = this.getBackground() == null ? Color.white : this.getBackground();
        g.setColor(color);
        g.fillRect(0, 0, r.width, r.height);
        color = this.getForeground() == null ? Color.black : this.getForeground();
        g.setColor(color);
        g.setFont(this.getFont());
        g.drawString(convertedText, x, y);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyListenerSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyListenerSupport.removePropertyChangeListener(listener);
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyListenerSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoListener) {
        this.vetoListenerSupport.addVetoableChangeListener(vetoListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoListener) {
        this.vetoListenerSupport.removeVetoableChangeListener(vetoListener);
    }

    protected void fireVetoableChange(String propertyName, Object oldValue, Object newValue) throws PropertyVetoException {
        this.vetoListenerSupport.fireVetoableChange(propertyName, oldValue, newValue);
    }
}

