/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureSelection;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.util.Clipboard;
import CH.ifa.draw.util.Command;
import java.util.Vector;

abstract class FigureTransferCommand
extends Command {
    protected DrawingView fView;

    protected FigureTransferCommand(String name, DrawingView view) {
        super(name);
        this.fView = view;
    }

    protected void deleteSelection() {
        this.fView.drawing().removeAll(this.fView.selection());
        this.fView.clearSelection();
    }

    protected void copySelection() {
        FigureSelection selection = this.fView.getFigureSelection();
        Clipboard.getClipboard().setContents(selection);
    }

    protected void insertFigures(Vector figures, int dx, int dy) {
        FigureEnumerator e = new FigureEnumerator(figures);
        while (e.hasMoreElements()) {
            Figure figure = e.nextFigure();
            figure.moveBy(dx, dy);
            figure = this.fView.add(figure);
            this.fView.addToSelection(figure);
        }
    }
}

