/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.AbstractTool;
import CH.ifa.draw.util.Geom;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class ConnectionTool
extends AbstractTool {
    private Connector fStartConnector;
    private Connector fEndConnector;
    private Connector fConnectorTarget = null;
    private Figure fTarget = null;
    private ConnectionFigure fConnection;
    private int fSplitPoint;
    private ConnectionFigure fEditedConnection = null;
    private ConnectionFigure fPrototype;

    public ConnectionTool(DrawingView view, ConnectionFigure prototype) {
        super(view);
        this.fPrototype = prototype;
    }

    @Override
    public void mouseMove(MouseEvent e, int x, int y) {
        this.trackConnectors(e, x, y);
    }

    @Override
    public void mouseDown(MouseEvent e, int x, int y) {
        int ex = e.getX();
        int ey = e.getY();
        this.fTarget = this.findConnectionStart(ex, ey, this.drawing());
        if (this.fTarget != null) {
            this.fStartConnector = this.findConnector(ex, ey, this.fTarget);
            if (this.fStartConnector != null) {
                Point p = new Point(ex, ey);
                this.fConnection = this.createConnection();
                this.fConnection.startPoint(p.x, p.y);
                this.fConnection.endPoint(p.x, p.y);
                this.view().add(this.fConnection);
            }
        } else {
            ConnectionFigure connection = this.findConnection(ex, ey, this.drawing());
            if (connection != null) {
                if (!connection.joinSegments(ex, ey)) {
                    this.fSplitPoint = connection.splitSegment(ex, ey);
                    this.fEditedConnection = connection;
                } else {
                    this.fEditedConnection = null;
                }
            }
        }
    }

    @Override
    public void mouseDrag(MouseEvent e, int x, int y) {
        Point p = new Point(e.getX(), e.getY());
        if (this.fConnection != null) {
            this.trackConnectors(e, x, y);
            if (this.fConnectorTarget != null) {
                p = Geom.center(this.fConnectorTarget.displayBox());
            }
            this.fConnection.endPoint(p.x, p.y);
        } else if (this.fEditedConnection != null) {
            Point pp = new Point(x, y);
            this.fEditedConnection.setPointAt(pp, this.fSplitPoint);
        }
    }

    @Override
    public void mouseUp(MouseEvent e, int x, int y) {
        Figure c = null;
        if (this.fStartConnector != null) {
            c = this.findTarget(e.getX(), e.getY(), this.drawing());
        }
        if (c != null) {
            this.fEndConnector = this.findConnector(e.getX(), e.getY(), c);
            if (this.fEndConnector != null) {
                this.fConnection.connectStart(this.fStartConnector);
                this.fConnection.connectEnd(this.fEndConnector);
                this.fConnection.updateConnection();
            }
        } else if (this.fConnection != null) {
            this.view().remove(this.fConnection);
        }
        this.fConnection = null;
        this.fEndConnector = null;
        this.fStartConnector = null;
        this.editor().toolDone();
    }

    @Override
    public void deactivate() {
        super.deactivate();
        if (this.fTarget != null) {
            this.fTarget.connectorVisibility(false);
        }
    }

    protected ConnectionFigure createConnection() {
        return (ConnectionFigure)this.fPrototype.clone();
    }

    protected Figure findSource(int x, int y, Drawing drawing) {
        return this.findConnectableFigure(x, y, drawing);
    }

    protected Figure findTarget(int x, int y, Drawing drawing) {
        Figure target = this.findConnectableFigure(x, y, drawing);
        Figure start = this.fStartConnector.owner();
        if (target != null && this.fConnection != null && target.canConnect() && !target.includes(start) && this.fConnection.canConnect(start, target)) {
            return target;
        }
        return null;
    }

    protected ConnectionFigure findConnection(int x, int y, Drawing drawing) {
        FigureEnumeration k = drawing.figuresReverse();
        while (k.hasMoreElements()) {
            Figure figure = (Figure)k.nextElement();
            if ((figure = figure.findFigureInside(x, y)) == null || !(figure instanceof ConnectionFigure)) continue;
            return (ConnectionFigure)figure;
        }
        return null;
    }

    protected ConnectionFigure createdFigure() {
        return this.fConnection;
    }

    protected void trackConnectors(MouseEvent e, int x, int y) {
        Figure c = null;
        c = this.fStartConnector == null ? this.findSource(x, y, this.drawing()) : this.findTarget(x, y, this.drawing());
        if (c != this.fTarget) {
            if (this.fTarget != null) {
                this.fTarget.connectorVisibility(false);
            }
            this.fTarget = c;
            if (this.fTarget != null) {
                this.fTarget.connectorVisibility(true);
            }
        }
        Connector cc = null;
        if (c != null) {
            cc = this.findConnector(e.getX(), e.getY(), c);
        }
        if (cc != this.fConnectorTarget) {
            this.fConnectorTarget = cc;
        }
        this.view().checkDamage();
    }

    private Connector findConnector(int x, int y, Figure f) {
        return f.connectorAt(x, y);
    }

    protected Figure findConnectionStart(int x, int y, Drawing drawing) {
        Figure target = this.findConnectableFigure(x, y, drawing);
        if (target != null && target.canConnect()) {
            return target;
        }
        return null;
    }

    private Figure findConnectableFigure(int x, int y, Drawing drawing) {
        FigureEnumeration k = drawing.figuresReverse();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            if (figure.includes(this.fConnection) || !figure.canConnect() || !figure.containsPoint(x, y)) continue;
            return figure;
        }
        return null;
    }

    protected Connector getStartConnector() {
        return this.fStartConnector;
    }

    protected Connector getEndConnector() {
        return this.fEndConnector;
    }

    protected Connector getTarget() {
        return this.fConnectorTarget;
    }
}

