/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.figures.RadiusHandle;
import CH.ifa.draw.figures.ShortestDistanceConnector;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.standard.BoxHandleKit;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Vector;

public class RoundRectangleFigure
extends AttributeFigure {
    private Rectangle fDisplayBox;
    private int fArcWidth;
    private int fArcHeight;
    private static final int DEFAULT_ARC = 8;
    private static final long serialVersionUID = 7907900248924036885L;
    private int roundRectangleSerializedDataVersion = 1;

    public RoundRectangleFigure() {
        this(new Point(0, 0), new Point(0, 0));
        this.fArcHeight = 8;
        this.fArcWidth = 8;
    }

    public RoundRectangleFigure(Point origin, Point corner) {
        this.basicDisplayBox(origin, corner);
        this.fArcHeight = 8;
        this.fArcWidth = 8;
    }

    @Override
    public void basicDisplayBox(Point origin, Point corner) {
        this.fDisplayBox = new Rectangle(origin);
        this.fDisplayBox.add(corner);
    }

    public void setArc(int width, int height) {
        this.willChange();
        this.fArcWidth = width;
        this.fArcHeight = height;
        this.changed();
    }

    public Point getArc() {
        return new Point(this.fArcWidth, this.fArcHeight);
    }

    @Override
    public Vector handles() {
        Vector<RadiusHandle> handles = new Vector<RadiusHandle>();
        BoxHandleKit.addHandles(this, handles);
        handles.addElement(new RadiusHandle(this));
        return handles;
    }

    @Override
    public Rectangle displayBox() {
        return new Rectangle(this.fDisplayBox.x, this.fDisplayBox.y, this.fDisplayBox.width, this.fDisplayBox.height);
    }

    @Override
    protected void basicMoveBy(int x, int y) {
        this.fDisplayBox.translate(x, y);
    }

    @Override
    public void drawBackground(Graphics g) {
        Rectangle r = this.displayBox();
        g.fillRoundRect(r.x, r.y, r.width, r.height, this.fArcWidth, this.fArcHeight);
    }

    @Override
    public void drawFrame(Graphics g) {
        Rectangle r = this.displayBox();
        g.drawRoundRect(r.x, r.y, r.width - 1, r.height - 1, this.fArcWidth, this.fArcHeight);
    }

    @Override
    public Insets connectionInsets() {
        return new Insets(this.fArcHeight / 2, this.fArcWidth / 2, this.fArcHeight / 2, this.fArcWidth / 2);
    }

    @Override
    public Connector connectorAt(int x, int y) {
        return new ShortestDistanceConnector(this);
    }

    @Override
    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this.fDisplayBox.x);
        dw.writeInt(this.fDisplayBox.y);
        dw.writeInt(this.fDisplayBox.width);
        dw.writeInt(this.fDisplayBox.height);
        dw.writeInt(this.fArcWidth);
        dw.writeInt(this.fArcHeight);
    }

    @Override
    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fDisplayBox = new Rectangle(dr.readInt(), dr.readInt(), dr.readInt(), dr.readInt());
        this.fArcWidth = dr.readInt();
        this.fArcHeight = dr.readInt();
    }
}

