/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.FigureAttributes;
import CH.ifa.draw.standard.AbstractFigure;
import CH.ifa.draw.util.ColorMap;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Color;
import java.awt.Graphics;
import java.io.IOException;
import java.io.ObjectOutputStream;

public abstract class AttributeFigure
extends AbstractFigure {
    private FigureAttributes fAttributes;
    private static FigureAttributes fgDefaultAttributes = null;
    private static final long serialVersionUID = -10857585979273442L;
    private int attributeFigureSerializedDataVersion = 1;

    protected AttributeFigure() {
    }

    @Override
    public void draw(Graphics g) {
        Color frame;
        Color fill = this.getFillColor();
        if (!ColorMap.isTransparent(fill)) {
            g.setColor(fill);
            this.drawBackground(g);
        }
        if (!ColorMap.isTransparent(frame = this.getFrameColor())) {
            g.setColor(frame);
            this.drawFrame(g);
        }
    }

    protected void drawBackground(Graphics g) {
    }

    protected void drawFrame(Graphics g) {
    }

    public Color getFillColor() {
        return (Color)this.getAttribute("FillColor");
    }

    public Color getFrameColor() {
        return (Color)this.getAttribute("FrameColor");
    }

    private static void initializeAttributes() {
        fgDefaultAttributes = new FigureAttributes();
        fgDefaultAttributes.set("FrameColor", Color.black);
        fgDefaultAttributes.set("FillColor", new Color(7396243));
        fgDefaultAttributes.set("TextColor", Color.black);
        fgDefaultAttributes.set("ArrowMode", new Integer(0));
        fgDefaultAttributes.set("FontName", "Helvetica");
        fgDefaultAttributes.set("FontSize", new Integer(12));
        fgDefaultAttributes.set("FontStyle", new Integer(0));
    }

    public static Object getDefaultAttribute(String name) {
        if (fgDefaultAttributes == null) {
            AttributeFigure.initializeAttributes();
        }
        return fgDefaultAttributes.get(name);
    }

    @Override
    public Object getAttribute(String name) {
        if (this.fAttributes != null && this.fAttributes.hasDefined(name)) {
            return this.fAttributes.get(name);
        }
        return AttributeFigure.getDefaultAttribute(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (this.fAttributes == null) {
            this.fAttributes = new FigureAttributes();
        }
        this.fAttributes.set(name, value);
        this.changed();
    }

    @Override
    public void write(StorableOutput dw) {
        super.write(dw);
        if (this.fAttributes == null) {
            dw.writeString("no_attributes");
        } else {
            dw.writeString("attributes");
            this.fAttributes.write(dw);
        }
    }

    @Override
    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        String s = dr.readString();
        if (s.toLowerCase().equals("attributes")) {
            this.fAttributes = new FigureAttributes();
            this.fAttributes.read(dr);
        }
    }

    private void writeObject(ObjectOutputStream o) throws IOException {
        Object associatedMenu = this.getAttribute("POPUP_MENU");
        if (associatedMenu != null) {
            this.setAttribute("POPUP_MENU", null);
        }
        o.defaultWriteObject();
        if (associatedMenu != null) {
            this.setAttribute("POPUP_MENU", associatedMenu);
        }
    }
}

