/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib;

import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.contrib.MDI_InternalFrame;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.standard.StandardDrawingView;
import java.beans.PropertyVetoException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

public class MDI_DrawApplication
extends DrawApplication
implements InternalFrameListener {
    private MDI_InternalFrame currentFrame;
    private StandardDrawingView backupDrawingView;
    private JComponent desktop;
    private Vector mdiListeners;

    public MDI_DrawApplication() {
        this("JHotDraw");
    }

    public MDI_DrawApplication(String title) {
        super(title);
        this.setDesktop(new JDesktopPane());
        this.getDesktop().setAlignmentX(0.0f);
        this.mdiListeners = new Vector();
        this.addInternalFrameListener(this);
    }

    @Override
    protected DrawApplication createApplication() {
        return new MDI_DrawApplication();
    }

    @Override
    protected JComponent createContents(StandardDrawingView view) {
        JComponent contents = super.createContents(view);
        MDI_InternalFrame internalFrame = this.createInternalFrame();
        internalFrame.setDrawingView(view);
        internalFrame.setSize(200, 200);
        internalFrame.getContentPane().add(contents);
        if (this.currentFrame == null) {
            this.currentFrame = internalFrame;
            this.backupDrawingView = this.createDrawingView();
        }
        Enumeration enumXX = this.mdiListeners.elements();
        while (enumXX.hasMoreElements()) {
            internalFrame.addInternalFrameListener((InternalFrameListener)enumXX.nextElement());
        }
        this.getDesktop().add(internalFrame);
        try {
            internalFrame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        internalFrame.setVisible(true);
        return this.getDesktop();
    }

    protected MDI_InternalFrame createInternalFrame() {
        return new MDI_InternalFrame("untitled", true, true, true, true);
    }

    @Override
    public void promptNew() {
        if (this.hasInternalFrames()) {
            super.promptNew();
        } else {
            this.newWindow();
        }
    }

    @Override
    public void newWindow() {
        StandardDrawingView fView = this.createDrawingView();
        Drawing fDrawing = this.createDrawing();
        fView.setDrawing(fDrawing);
        this.createContents(fView);
        this.toolDone();
    }

    @Override
    public void newView() {
        String copyTitle = this.getDrawingTitle();
        StandardDrawingView fView = this.createDrawingView();
        fView.setDrawing(this.drawing());
        this.createContents(fView);
        this.setDrawingTitle(copyTitle + " (View)");
        this.toolDone();
    }

    protected void setDesktop(JComponent newDesktop) {
        this.desktop = newDesktop;
    }

    public JComponent getDesktop() {
        return this.desktop;
    }

    public void addInternalFrameListener(InternalFrameListener newMDIListener) {
        this.mdiListeners.addElement(newMDIListener);
    }

    public void removeInternalFrameListener(InternalFrameListener oldMDIListener) {
        this.mdiListeners.removeElement(oldMDIListener);
    }

    public void activateFrame(MDI_InternalFrame newFrame) {
        if (this.currentFrame != newFrame) {
            if (newFrame.getDrawingView().drawing() != null) {
                newFrame.getDrawingView().unfreezeView();
            }
            this.backupDrawingView.setDrawing(this.view().drawing());
            this.currentFrame.replaceDrawingView(this.backupDrawingView);
            this.currentFrame.validate();
            this.currentFrame.getDrawingView().freezeView();
            this.setDrawing(newFrame.getDrawingView().drawing());
            this.backupDrawingView = newFrame.replaceDrawingView((StandardDrawingView)this.view());
            this.currentFrame = newFrame;
        }
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent e) {
        this.activateFrame((MDI_InternalFrame)e.getSource());
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent e) {
        this.activateFrame((MDI_InternalFrame)e.getSource());
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent e) {
    }

    @Override
    protected void setDrawingTitle(String newDrawingTitle) {
        this.currentFrame.setTitle(newDrawingTitle);
    }

    @Override
    protected String getDrawingTitle() {
        return this.currentFrame.getTitle();
    }

    public boolean hasInternalFrames() {
        return ((JDesktopPane)this.getDesktop()).getAllFrames().length > 0;
    }
}

