/*
 * Decompiled with CFR 0.152.
 */
package vmm.xm3d;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.JApplet;
import javax.swing.JButton;
import vmm.core.Exhibit;
import vmm.core.I18n;
import vmm.core.SaveAndRestore;
import vmm.core.UserExhibit;
import vmm.core.View;
import vmm.xm3d.DisplayXM;
import vmm.xm3d.MainForWebStart;
import vmm.xm3d.WindowXM;

public class LauncherApplet
extends JApplet {
    private JButton launchButton;
    private String openString;
    private String closeString;
    private String exhibitName;
    private ArrayList<WindowXM> openWindows = new ArrayList();

    @Override
    public void init() {
        String locale = this.getParameter("Locale");
        if (locale != null && locale.length() == 2) {
            I18n.setLocale(new Locale(locale));
        }
        I18n.addFile("vmm.xm3d.stringsXM");
        DisplayXM.noSplash();
        this.openString = this.getParameter("OpenCommand");
        if (this.openString == null) {
            this.openString = I18n.tr("3dxm.LauncherApplet.OpenCommand");
        }
        this.closeString = this.getParameter("CloseCommand");
        if (this.closeString == null) {
            this.closeString = I18n.tr("3dxm.LauncherApplet.CloseCommand");
        }
        this.exhibitName = this.getParameter("Exhibit");
        this.launchButton = new JButton(this.openString);
        this.getContentPane().add(this.launchButton);
        this.launchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LauncherApplet.this.doButton();
            }
        });
    }

    private void doButton() {
        this.launchButton.setEnabled(false);
        if (this.openWindows.size() == 0) {
            Exhibit exhibit = null;
            View view = null;
            int menuOptionFlags = 17;
            if (this.exhibitName != null) {
                try {
                    if (this.exhibitName.endsWith(".xml")) {
                        ClassLoader cl = MainForWebStart.class.getClassLoader();
                        URL url = cl.getResource(this.exhibitName);
                        if (url == null) {
                            url = new URL(this.getDocumentBase(), this.exhibitName);
                        }
                        InputStream settings = url.openStream();
                        exhibit = SaveAndRestore.readExhibitFromXML(settings, "Settings File");
                        view = exhibit.getViews().get(0);
                    } else {
                        exhibit = (Exhibit)Class.forName(this.exhibitName).newInstance();
                        if (exhibit instanceof UserExhibit) {
                            view = ((UserExhibit)((Object)exhibit)).getUserExhibitSupport().showCreateDialog(null);
                            if (view == null) {
                                this.launchButton.setEnabled(true);
                                return;
                            }
                        } else {
                            view = exhibit.getDefaultView();
                        }
                    }
                }
                catch (Exception e) {
                    System.out.println("Can't load Exhibit specified by applet param \"" + this.exhibitName + "\"");
                    e.printStackTrace();
                    exhibit = null;
                    view = null;
                    return;
                }
                if ("yes".equalsIgnoreCase(this.getParameter("SingleExhibit"))) {
                    menuOptionFlags |= 4;
                } else if ("yes".equalsIgnoreCase(this.getParameter("SingleGallery"))) {
                    menuOptionFlags |= 8;
                }
            }
            WindowXM window = new WindowXM(this, menuOptionFlags);
            if (exhibit != null) {
                window.getMenus().install(view, exhibit);
            }
            window.setVisible(true);
        } else {
            for (WindowXM window : this.openWindows) {
                window.dispose();
            }
        }
    }

    void windowClosed(WindowXM window) {
        this.openWindows.remove(window);
        if (this.openWindows.size() == 0) {
            this.launchButton.setText(this.openString);
            this.launchButton.setEnabled(true);
        }
    }

    void windowOpened(WindowXM window) {
        this.launchButton.setText(this.closeString);
        this.launchButton.setEnabled(true);
        this.openWindows.add(window);
    }
}

