/*
 * Decompiled with CFR 0.152.
 */
package vmm.xm3d;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import vmm.core.Display;
import vmm.core.Exhibit;
import vmm.core.I18n;
import vmm.core.View;

public class DisplayXM
extends Display {
    private static String backgroundURL = "vmm/resources/splash_background.jpeg";
    private static boolean firstWindow = true;
    private volatile Image splashBackground;

    public DisplayXM() {
        this.getInputMap(2).put(KeyStroke.getKeyStroke("control PERIOD"), "reset");
        this.getInputMap(2).put(KeyStroke.getKeyStroke("meta PERIOD"), "reset");
        this.getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "reset");
        this.getInputMap(2).put(KeyStroke.getKeyStroke("SPACE"), "pause");
        this.getActionMap().put("reset", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DisplayXM.this.stopAnimation();
            }
        });
        this.getActionMap().put("pause", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DisplayXM.this.toggleAnimationPaused();
            }
        });
        if (firstWindow) {
            try {
                URL imageURL = this.getClass().getClassLoader().getResource(backgroundURL);
                if (imageURL != null) {
                    this.splashBackground = Toolkit.getDefaultToolkit().createImage(imageURL);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            firstWindow = false;
        }
    }

    static void noSplash() {
        firstWindow = false;
    }

    @Override
    public void install(View view, Exhibit exhibit) {
        super.install(view, exhibit);
        if (this.getExhibit() != null) {
            this.splashBackground = null;
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.getStatus() == "empty") {
            if (this.splashBackground != null) {
                g.drawImage(this.splashBackground, 0, 0, this.getWidth(), this.getHeight(), this);
                this.showWelcomeMessage(g);
            } else {
                g.setColor(Color.red);
                g.drawString(I18n.tr("3dxm.DisplayXM.SelectExhibitMessage"), 15, 30);
            }
        }
    }

    private void showWelcomeMessage(Graphics g) {
        g.setFont(new Font("Serif", 1, 18));
        String message = I18n.tr("3dxm.DisplayXM.WelcomeMessage");
        String version = I18n.tr("application.nameAndVersion");
        String[] msg = message.split("\n");
        String[] lines = new String[msg.length + 1];
        lines[0] = version;
        for (int i = 0; i < msg.length; ++i) {
            lines[i + 1] = msg[i];
        }
        FontMetrics fm = g.getFontMetrics();
        int lineheight = fm.getAscent() + fm.getDescent() + fm.getLeading() + 12;
        int y = fm.getAscent() + (this.getHeight() - lineheight * lines.length) / 2;
        int width = 0;
        for (int i = 0; i < lines.length; ++i) {
            int linewidth = fm.stringWidth(lines[i]);
            if (linewidth <= width) continue;
            width = linewidth;
        }
        int x = (this.getWidth() - width) / 2;
        g.setColor(Color.RED);
        for (int i = 0; i < lines.length; ++i) {
            g.drawString(lines[i], x + (width - fm.stringWidth(lines[i])) / 2, y);
            y += lineheight;
        }
    }
}

