/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import vmm.core.Complex;
import vmm.core.IntegerParam;
import vmm.core.RealParamAnimateable;
import vmm.core.View;
import vmm.core3D.ComplexVector3D;
import vmm.core3D.GridTransformMatrix;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.WeierstrassMinimalSurface;

public class Skew_K_noid
extends WeierstrassMinimalSurface {
    private IntegerParam exponent = new IntegerParam("vmm.surface.parametric.Skew_K_noid.MainEx", 2);
    private RealParamAnimateable aa = new RealParamAnimateable("vmm.surface.parametric.Skew_K_noid.aa", 0.4, 0.0, 0.93);
    private int ex;
    private int e_odd;
    private int j0;
    private double AA;
    private double r1;
    private double rex;
    private double re_e;
    private double mob;
    private Complex q1;

    public Skew_K_noid() {
        this.afp.reset(0.0, 0.0, 0.0);
        this.addParameter(this.aa);
        this.aa.setMaximumValueForInput(0.95);
        this.aa.setMinimumValueForInput(0.0);
        this.addParameter(this.exponent);
        this.exponent.setMinimumValueForInput(2);
        this.setDefaultViewpoint(new Vector3D(-2.0, 14.0, -50.0));
        this.setDefaultOrientation(1);
        this.setDefaultWindow(-4.0, 4.0, -3.0, 3.0);
        this.uPatchCount.setValueAndDefault(12);
        this.vPatchCount.setValueAndDefault(20);
        this.umin.reset(-2.5);
        this.umax.reset(0.0);
        this.vmin.reset(-1.5707963267948966);
        this.vmax.reset(1.5707963267948966);
        this.umin.setMaximumValueForInput(-0.05);
        this.removeParameter(this.umax);
        this.removeParameter(this.vmax);
        this.removeParameter(this.vmin);
        this.canShowConjugateSurface = true;
    }

    @Override
    public View getDefaultView() {
        WeierstrassMinimalSurface.WMSView view = new WeierstrassMinimalSurface.WMSView(this);
        view.setGridSpacing(12);
        return view;
    }

    @Override
    protected void createData() {
        super.createData();
        this.data.discardGridTransforms();
        if (!this.inAssociateMorph) {
            int e;
            GridTransformMatrix[] trList = new GridTransformMatrix[this.ex * 4];
            trList[0] = new GridTransformMatrix();
            if (this.flag0) {
                trList[1] = new GridTransformMatrix().scale(1.0, -1.0, 1.0);
                this.data.addGridTransform(trList[1]);
            } else if (this.flag05) {
                trList[1] = new GridTransformMatrix().scale(-1.0, 1.0, -1.0).reverse();
                this.data.addGridTransform(trList[1]);
            }
            if (this.flag0 || this.flag05) {
                for (e = 1; e < this.ex; ++e) {
                    trList[2 * e] = new GridTransformMatrix(trList[2 * e - 2]).rotateZ(360.0 / (double)this.ex);
                    this.data.addGridTransform(trList[2 * e]);
                    trList[2 * e + 1] = new GridTransformMatrix(trList[2 * e - 1]).rotateZ(360.0 / (double)this.ex);
                    this.data.addGridTransform(trList[2 * e + 1]);
                }
            }
            if (this.flag0) {
                for (e = 0; e < 2 * this.ex; ++e) {
                    trList[2 * this.ex + e] = new GridTransformMatrix(trList[e]).scale(1.0, 1.0, -1.0);
                    this.data.addGridTransform(trList[2 * this.ex + e]);
                }
            }
        }
    }

    @Override
    protected Complex domainGrid(double u, double v) {
        double r = Math.exp(u);
        Complex z = new Complex(r * Math.cos(v), r * Math.sin(v));
        Complex w = new Complex(-z.re + 1.0, -z.im);
        Complex aux = new Complex(z.im, -z.re - 1.0);
        w.assignDivide(aux);
        w = w.mobius1_1(this.mob);
        z = w.logNearer(I_C);
        z.assignTimes(1.0 / (double)this.ex);
        return z.exponential();
    }

    protected void zeroIndex() {
        double test = 10.0;
        for (int j = 0; j < this.vcount; ++j) {
            double aux = this.domainGrid(this.umax.getValue(), this.vmin.getValue() + (double)j * this.dv).r();
            if (!(aux <= test)) continue;
            test = aux;
            this.j0 = j;
        }
    }

    @Override
    protected Complex gauss(Complex z) {
        Complex wk = z.integerPower(this.ex - 1);
        Complex w = z.times(wk);
        Complex aux = w.times(-this.rex);
        aux.re += 1.0;
        w.re -= this.rex;
        w = wk.times(w).dividedBy(aux);
        return w;
    }

    @Override
    protected Complex hPrime(Complex z) {
        Complex wk = z.integerPower(this.ex - 1);
        Complex w = z.times(wk);
        Complex w2 = w.times(w);
        w2.re += 1.0;
        Complex aux = w2.times(-this.re_e);
        aux.assignPlus(w);
        aux.assignTimes(wk);
        w2.re -= 4.0 * this.re_e * w.re;
        w2.im -= 4.0 * this.re_e * w.im;
        w2.assignTimes(w2);
        w2.assignTimes(this.r1);
        return aux.dividedBy(w2);
    }

    @Override
    protected void redoConstants() {
        super.redoConstants();
        this.AA = Math.sqrt(this.aa.getValue());
        this.ex = this.exponent.getValue();
        this.rex = Math.pow(this.AA, this.ex);
        this.re_e = this.rex / (this.rex * this.rex + 1.0);
        this.r1 = 1.0 / (1.0 - this.AA * this.AA * this.AA * this.AA) * Math.sqrt(2.0 / (double)this.ex);
        double ck = 2.0 * this.re_e;
        double sk = Math.sqrt(1.0 - ck * ck);
        this.mob = Math.sqrt((1.0 - sk) / (1.0 - ck) / 2.0);
        this.zeroIndex();
    }

    @Override
    protected ComplexVector3D getCenter() {
        ComplexVector3D gC = new ComplexVector3D(this.helperArray[this.ucount - 1][this.j0]);
        gC = gC.plus(this.ComplexVectorOneStepIntegrator(this.domainGrid(this.umax.getValue(), this.vmin.getValue() + (double)this.j0 * this.dv), del));
        if (!this.inAssociateMorph) {
            gC.z = new Complex(this.helperArray[this.ucount - 1][0].z);
        }
        return gC;
    }

    @Override
    public Vector3D surfacePoint(double u, double v) {
        int i = (int)Math.floor(0.25 + (u - this.umin.getValue()) / this.du);
        int j = (int)Math.floor(0.25 + (v - this.vmin.getValue()) / this.dv);
        ComplexVector3D auxW = new ComplexVector3D(this.helperArray[i][j].plus(this.ComplexVectorOneStepIntegrator(this.domainGrid(this.umin.getValue() + (double)i * this.du, this.vmin.getValue() + (double)j * this.dv), this.domainGrid(u, v))));
        ComplexVector3D eW = new ComplexVector3D(auxW.y.minus(auxW.x), auxW.y.plus(auxW.x).times(I_C), auxW.z);
        if (i == this.ucount - 1 && j == this.j0) {
            eW = new ComplexVector3D(ZERO_C, ZERO_C, eW.z);
        }
        if (this.AFP == 0.0) {
            return eW.re();
        }
        return eW.re().times(Math.cos(this.AFP)).plus(eW.im().times(Math.sin(this.AFP)));
    }

    public void createIntegrationGrid() {
        double u = this.umin.getValue();
        double v = this.vmin.getValue();
    }
}

