/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import java.awt.Color;
import vmm.core.Complex;
import vmm.core.RealParamAnimateable;
import vmm.core.View;
import vmm.core3D.ComplexVector3D;
import vmm.core3D.GridTransformMatrix;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.WeierstrassMinimalSurface;

public class SchwarzPDsurface
extends WeierstrassMinimalSurface {
    private RealParamAnimateable aa = new RealParamAnimateable("vmm.surface.parametric.SchwarzPDsurface.aa", 0.2, 0.48, 0.02);
    private RealParamAnimateable bb = new RealParamAnimateable("vmm.surface.parametric.SchwarzPDsurface.bb", 0.6, 0.52, 0.98);
    private int um;
    private int vm;
    private double Phi1;
    private double Phi2;
    private double rp1;
    private double RP2;
    private double r1_;
    private double R2_;
    private double scale;
    private Complex xWidth;
    private Complex yWidth;
    private Complex zWidth;
    private Vector3D centerRE;
    private Vector3D centerRE_;
    private Vector3D centerIM;
    private Vector3D trans;

    public SchwarzPDsurface() {
        this.addParameter(this.bb);
        this.bb.setMaximumValueForInput(0.99);
        this.bb.setMinimumValueForInput(0.05);
        this.addParameter(this.aa);
        this.aa.setMaximumValueForInput(0.95);
        this.aa.setMinimumValueForInput(0.02);
        this.setDefaultOrientation(1);
        this.setDefaultViewUp(new Vector3D(-0.045, 0.4, 0.915));
        this.setDefaultViewpoint(new Vector3D(12.0, -44.0, 20.0));
        this.setDefaultWindow(-3.0, 3.0, -2.8, 2.2);
        this.uPatchCount.setValueAndDefault(12);
        this.vPatchCount.setValueAndDefault(12);
        this.umin.reset(0.005);
        this.umax.reset(0.995);
        this.vmin.reset(0.0);
        this.vmax.reset(1.0);
        this.removeParameter(this.vmin);
        this.removeParameter(this.vmax);
        this.removeParameter(this.umin);
        this.removeParameter(this.umax);
        this.iFirstInHelper = false;
        this.wantsToSeeDomain = false;
        this.wantsToSeeGaussImage = false;
        if (this.wantsToSeeGaussImage) {
            this.wantsToSeeDomain = true;
        }
        if (this.wantsToSeeDomain) {
            this.setDefaultViewUp(new Vector3D(0.0, 0.0, 1.0));
            this.setDefaultViewpoint(new Vector3D(0.0, 0.0, 40.0));
        }
        this.multipleCopyOptions = new int[]{2};
        this.canShowConjugateSurface = true;
    }

    @Override
    public View getDefaultView() {
        WeierstrassMinimalSurface.WMSView view = new WeierstrassMinimalSurface.WMSView(this);
        view.setGridSpacing(12);
        float c0 = 0.2f;
        view.getLightSettings().setAmbientLight(new Color(c0, c0, c0));
        view.getLightSettings().setSpecularExponent(100);
        view.getLightSettings().setSpecularRatio(0.8f);
        return view;
    }

    @Override
    protected void createData() {
        super.createData();
        this.computePeriodData();
        this.data.discardGridTransforms();
        GridTransformMatrix[] trList = new GridTransformMatrix[64];
        trList[0] = new GridTransformMatrix();
        GridTransformMatrix a = new GridTransformMatrix();
        trList[1] = new GridTransformMatrix().scale(-1.0, -1.0, -1.0).reverse();
        if (!this.wantsToSeeDomain) {
            this.data.addGridTransform(trList[1]);
            if (!this.inAssociateMorph) {
                int e;
                if (this.flag0) {
                    a = new GridTransformMatrix().scale(-1.0, -1.0, 1.0);
                    this.trans = new Vector3D(this.centerRE.x, this.centerRE.y, 0.0);
                    trList[2] = new GridTransformMatrix(trList[0]).leftMultiplyBy(a).translate(this.trans);
                    trList[3] = new GridTransformMatrix(trList[1]).leftMultiplyBy(a).translate(this.trans);
                    this.data.addGridTransform(trList[2]);
                    this.data.addGridTransform(trList[3]);
                    a = new GridTransformMatrix().scale(1.0, -1.0, -1.0);
                    this.trans = new Vector3D(0.0, this.centerRE.y, this.centerRE.z);
                    for (e = 0; e < 4; ++e) {
                        trList[4 + e] = new GridTransformMatrix(trList[e]).leftMultiplyBy(a).translate(this.trans);
                        this.data.addGridTransform(trList[4 + e]);
                    }
                    a = new GridTransformMatrix().scale(-1.0, -1.0, -1.0);
                    for (e = 0; e < 8; ++e) {
                        trList[8 + e] = new GridTransformMatrix(trList[e]).leftMultiplyBy(a).translate(this.centerRE);
                        this.data.addGridTransform(trList[8 + e]);
                    }
                    this.trans = new Vector3D(this.centerRE.x, this.centerRE.y, -this.centerRE.z);
                    for (e = 0; e < 4; ++e) {
                        trList[16 + e] = new GridTransformMatrix(trList[e]).leftMultiplyBy(a).translate(this.trans);
                        this.data.addGridTransform(trList[16 + e]);
                        trList[20 + e] = new GridTransformMatrix(trList[12 + e]).leftMultiplyBy(a).translate(this.trans);
                        this.data.addGridTransform(trList[20 + e]);
                    }
                    if (this.getNumberOfPieces() == 2) {
                        this.trans = new Vector3D(4.0 * this.xWidth.re, 0.0, 0.0);
                        for (e = 0; e < 24; ++e) {
                            trList[24 + e] = new GridTransformMatrix(trList[e]).translate(this.trans);
                            this.data.addGridTransform(trList[24 + e]);
                        }
                    }
                }
                if (this.flag05) {
                    a = new GridTransformMatrix().scale(-1.0, -1.0, 1.0).reverse();
                    this.trans = new Vector3D(this.centerIM.x, this.centerIM.y, 0.0);
                    trList[2] = new GridTransformMatrix(trList[0]).leftMultiplyBy(a).translate(this.trans);
                    trList[3] = new GridTransformMatrix(trList[1]).leftMultiplyBy(a).translate(this.trans);
                    this.data.addGridTransform(trList[2]);
                    this.data.addGridTransform(trList[3]);
                    a = new GridTransformMatrix().scale(1.0, -1.0, -1.0).reverse();
                    this.trans = new Vector3D(0.0, this.centerIM.y, this.centerIM.z);
                    trList[4] = new GridTransformMatrix(trList[0]).leftMultiplyBy(a).translate(this.trans);
                    trList[5] = new GridTransformMatrix(trList[1]).leftMultiplyBy(a).translate(this.trans);
                    this.data.addGridTransform(trList[4]);
                    this.data.addGridTransform(trList[5]);
                    a = new GridTransformMatrix().scale(-1.0, 1.0, -1.0);
                    this.trans = new Vector3D(this.centerIM.x, 0.0, this.centerIM.z);
                    trList[6] = new GridTransformMatrix(trList[0]).leftMultiplyBy(a).translate(this.trans);
                    trList[7] = new GridTransformMatrix(trList[1]).leftMultiplyBy(a).translate(this.trans);
                    this.data.addGridTransform(trList[6]);
                    this.data.addGridTransform(trList[7]);
                    a = new GridTransformMatrix().scale(1.0, -1.0, -1.0).reverse();
                    this.trans = new Vector3D(0.0, -this.centerIM.y, -this.centerIM.z);
                    trList[8] = new GridTransformMatrix(trList[0]).leftMultiplyBy(a).translate(this.trans);
                    trList[9] = new GridTransformMatrix(trList[1]).leftMultiplyBy(a).translate(this.trans);
                    this.data.addGridTransform(trList[8]);
                    this.data.addGridTransform(trList[9]);
                    this.trans = new Vector3D(2.0 * this.centerIM.x, 0.0, 2.0 * this.centerIM.z);
                    trList[10] = new GridTransformMatrix(trList[8]).translate(this.trans);
                    trList[11] = new GridTransformMatrix(trList[9]).translate(this.trans);
                    this.data.addGridTransform(trList[10]);
                    this.data.addGridTransform(trList[11]);
                    a = new GridTransformMatrix().scale(-1.0, 1.0, -1.0).reverse();
                    this.trans = new Vector3D(this.centerIM.x, 0.0, -1.0 * this.centerIM.z);
                    trList[12] = new GridTransformMatrix(trList[8]).leftMultiplyBy(a).translate(this.trans);
                    trList[13] = new GridTransformMatrix(trList[9]).leftMultiplyBy(a).translate(this.trans);
                    this.data.addGridTransform(trList[12]);
                    this.data.addGridTransform(trList[13]);
                    this.trans = new Vector3D(0.0, -2.0 * this.centerIM.y, 0.0);
                    trList[14] = new GridTransformMatrix(trList[0]).translate(this.trans);
                    trList[15] = new GridTransformMatrix(trList[1]).translate(this.trans);
                    this.data.addGridTransform(trList[14]);
                    this.data.addGridTransform(trList[15]);
                    if (this.getNumberOfPieces() == 2) {
                        a = new GridTransformMatrix().scale(-1.0, -1.0, 1.0).reverse();
                        this.trans = new Vector3D(-this.centerIM.x, -this.centerIM.y, 0.0);
                        for (e = 0; e < 16; ++e) {
                            trList[16 + e] = new GridTransformMatrix(trList[e]).leftMultiplyBy(a).translate(this.trans);
                            this.data.addGridTransform(trList[16 + e]);
                        }
                    }
                }
            }
        }
    }

    public static double paramRescale(double x) {
        double y = Math.sin(1.5707963267948966 * x);
        return y * y;
    }

    @Override
    protected Complex domainGrid(double u, double v) {
        double ph = 0.0;
        double r = Math.sin(1.5707963267948966 * u);
        if (v <= 0.3333333333333333) {
            ph = -Math.PI + this.Phi1 * SchwarzPDsurface.paramRescale(3.0 * v);
        } else if (v > 0.3333333333333333 && v <= 0.6666666666666666) {
            ph = -Math.PI + this.Phi1 + (this.Phi2 - this.Phi1) * SchwarzPDsurface.paramRescale(3.0 * v - 1.0);
        } else if (v > 0.6666666666666666) {
            ph = -Math.PI + this.Phi2 + (Math.PI - this.Phi2) * SchwarzPDsurface.paramRescale(3.0 * v - 2.0);
        }
        Complex z = new Complex(r * Math.cos(ph), r * Math.sin(ph));
        if (this.wantsToSeeGaussImage) {
            z = this.gauss(z);
        }
        return z;
    }

    @Override
    protected Complex gauss(Complex z) {
        Complex z2 = z.times(z);
        Complex z2_ = new Complex(1.0 - z2.re, -z2.im);
        z2.re = 1.0 + z2.re;
        Complex w = z2_.inverse().times(z2);
        double x = -2.0 * w.im - this.r1_;
        w.im = 2.0 * w.re;
        w.re = x;
        Complex aux = w.times(-2.0 / (this.R2_ - this.r1_));
        aux.re = -aux.re - 1.0;
        aux.im = -aux.im;
        Complex aux2 = aux.times(aux);
        aux2.re -= 1.0;
        Complex g2 = aux2.squareRootNearer(aux).minus(aux);
        return g2.squareRootNearer(I1_C);
    }

    @Override
    protected Complex hPrime(Complex z) {
        Complex z2 = z.times(z);
        z2.re -= 1.0;
        Complex w = this.gauss(z);
        Complex g2 = w.times(w);
        Complex g4 = g2.times(g2);
        g4.re -= 1.0;
        g4.assignTimes(z2);
        w = g4.inverse().times(g2);
        w.assignTimes(this.scale);
        return w;
    }

    @Override
    protected void redoConstants() {
        super.redoConstants();
        this.Phi1 = Math.PI * this.aa.getValue();
        this.Phi2 = Math.PI * this.bb.getValue();
        this.rp1 = Math.tan(this.Phi1 / 2.0);
        this.RP2 = Math.tan(this.Phi2 / 2.0);
        this.r1_ = this.rp1 - 1.0 / this.rp1;
        this.R2_ = this.RP2 - 1.0 / this.RP2;
        this.scale = Math.sqrt(Math.sqrt((0.1 + this.aa.getValue()) * (1.1 - this.bb.getValue())) / (this.bb.getValue() - this.aa.getValue()));
        this.um = 1;
        this.vm = 1;
    }

    @Override
    protected ComplexVector3D getCenter() {
        ComplexVector3D gC = new ComplexVector3D(this.helperArray[0][0]);
        gC = gC.plus(this.helperArray[0][this.vcount - 1]).times(0.5);
        return gC;
    }

    public void computePeriodData() {
        ComplexVector3D aux;
        if (this.flag0) {
            aux = new ComplexVector3D(this.helperToMinimal(this.helperArray[this.ucount - 1][(int)Math.floor(this.vcount * 5 / 6)]));
            this.xWidth = aux.x;
            aux = new ComplexVector3D(this.helperToMinimal(this.helperArray[this.ucount - 1][(int)Math.floor(this.vcount / 2)]));
            this.zWidth = aux.z;
            aux = new ComplexVector3D(this.helperToMinimal(this.helperArray[this.ucount - 1][(int)Math.floor(this.vcount / 6)]));
            this.yWidth = aux.y;
            this.centerRE = new Vector3D(-2.0 * this.xWidth.re, -2.0 * this.yWidth.re, -2.0 * this.zWidth.re);
            this.centerRE_ = new Vector3D(2.0 * this.xWidth.re, 2.0 * this.yWidth.re, 2.0 * this.zWidth.re);
        }
        if (this.flag05) {
            aux = new ComplexVector3D(this.helperToMinimal(this.helperArray[this.ucount - 1][(int)Math.floor(this.vcount * 5 / 6)]));
            this.zWidth = aux.z;
            aux = new ComplexVector3D(this.helperToMinimal(this.helperArray[this.ucount - 1][(int)Math.floor(this.vcount / 2)]));
            this.yWidth = aux.y;
            aux = new ComplexVector3D(this.helperToMinimal(this.helperArray[this.ucount - 1][(int)Math.floor(this.vcount / 6)]));
            this.xWidth = aux.x;
            this.centerIM = new Vector3D(2.0 * this.xWidth.im, 2.0 * this.yWidth.im, 2.0 * this.zWidth.im);
        }
    }
}

