/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import java.awt.event.ActionEvent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import vmm.actions.AbstractActionVMM;
import vmm.actions.ActionList;
import vmm.core.BasicAnimator;
import vmm.core.I18n;
import vmm.core.RealParamAnimateable;
import vmm.core.View;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.SurfaceParametric;

public class KleinBottle
extends SurfaceParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("genericParam.aa", 3.0, 3.0, 3.0);
    boolean in2ndMorph = false;

    public KleinBottle() {
        this.setDefaultViewpoint(new Vector3D(10.0, -10.0, 10.0));
        this.setDefaultWindow(-4.0, 4.0, -4.0, 4.0);
        this.umin.reset("0.0", "-0.3", "-pi");
        this.umax.reset("2*pi", "0.3", "pi");
        this.vmin.reset("0.0", "0.1", "0.1");
        this.vmax.reset("2*pi", "2*pi", "2*pi");
        this.uPatchCount.setValueAndDefault(18);
        this.vPatchCount.setValueAndDefault(24);
        this.setDefaultOrientation(2);
        this.addParameter(this.aa);
    }

    private static double sin(double t) {
        return Math.sin(t);
    }

    private static double cos(double t) {
        return Math.cos(t);
    }

    @Override
    public ActionList getAdditionalAnimationsForView(final View view) {
        ActionList actions = super.getAdditionalAnimationsForView(view);
        actions.add(new AbstractActionVMM(I18n.tr("vmm.surface.parametric.KleinBottle.Twisting8")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicAnimator animation = new BasicAnimator();
                animation.setLooping(2);
                animation.setUseFilmstrip(KleinBottle.this.getUseFilmstripForMorphing());
                animation.setFrames(KleinBottle.this.getFramesForMorphing());
                animation.setMillisecondsPerFrame(200);
                animation.addWithCustomValue(KleinBottle.this.umin, 0.0);
                animation.addWithCustomValue(KleinBottle.this.umax, Math.PI * 2);
                animation.addWithCustomLimits(KleinBottle.this.vmin, 0.0, 0.0);
                animation.addWithCustomLimits(KleinBottle.this.vmax, 0.2, Math.PI * 2);
                animation.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent evt) {
                        KleinBottle.this.in2ndMorph = ((BasicAnimator)evt.getSource()).isRunning();
                    }
                });
                view.getDisplay().installAnimation(animation);
            }
        });
        return actions;
    }

    @Override
    public Vector3D surfacePoint(double u, double v) {
        double AA = this.aa.getValue();
        return new Vector3D((AA + KleinBottle.cos(v / 2.0) * KleinBottle.sin(u) - KleinBottle.sin(v / 2.0) * KleinBottle.sin(2.0 * u)) * KleinBottle.cos(v), (AA + KleinBottle.cos(v / 2.0) * KleinBottle.sin(u) - KleinBottle.sin(v / 2.0) * KleinBottle.sin(2.0 * u)) * KleinBottle.sin(v), KleinBottle.sin(v / 2.0) * KleinBottle.sin(u) + KleinBottle.cos(v / 2.0) * KleinBottle.sin(2.0 * u));
    }
}

