/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import vmm.core.RealParamAnimateable;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.SurfaceParametric;

public class Henneberg
extends SurfaceParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("genericParam.aa", 0.0, 0.0, 1.5707963267948966);

    public Henneberg() {
        this.uPatchCount.setValueAndDefault(8);
        this.vPatchCount.setValueAndDefault(24);
        this.umin.reset(0.35);
        this.umax.reset(0.85);
        this.vmin.reset("-pi");
        this.vmax.reset("pi");
        this.setDefaultViewpoint(new Vector3D(10.0, -10.0, 10.0));
        this.setDefaultWindow(-8.0, 8.0, -8.0, 8.0);
        this.addParameter(this.aa);
    }

    private static double sinh(double t) {
        return 0.5 * (Math.exp(t) - Math.exp(-t));
    }

    private static double cosh(double t) {
        return 0.5 * (Math.exp(t) + Math.exp(-t));
    }

    @Override
    public Vector3D surfacePoint(double u, double v) {
        double PI = Math.PI;
        double AA = this.aa.getValue();
        double x = -2.0 * Math.cos(AA * PI) * (-Henneberg.sinh(u) * Math.cos(v) + Henneberg.sinh(3.0 * u) * Math.cos(3.0 * v) / 3.0) - 2.0 * Math.sin(AA * PI) * (-Henneberg.cosh(u) * Math.sin(v) + Henneberg.cosh(3.0 * u) * Math.sin(3.0 * v) / 3.0);
        double y = -2.0 * Math.cos(AA * PI) * (-Henneberg.sinh(u) * Math.sin(v) - Henneberg.sinh(3.0 * u) * Math.sin(3.0 * v) / 3.0) - 2.0 * Math.sin(AA * PI) * (Henneberg.cosh(u) * Math.cos(v) + Henneberg.cosh(3.0 * u) * Math.cos(3.0 * v) / 3.0);
        double z = 2.0 * Math.cos(AA * PI) * (-1.0 + Henneberg.cosh(2.0 * u) * Math.cos(2.0 * v)) + 2.0 * Math.sin(AA * PI) * (Henneberg.sinh(2.0 * u) * Math.sin(2.0 * v));
        return new Vector3D(x, y, z);
    }
}

