/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import vmm.core.RealParamAnimateable;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.SurfaceParametric;

public class CrossCap
extends SurfaceParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("genericParam.aa", 1.3, 1.2, 1.4);

    public CrossCap() {
        this.setDefaultViewpoint(new Vector3D(10.0, -10.0, 10.0));
        this.setDefaultWindow(-2.0, 2.0, -2.0, 2.0);
        this.umin.reset("0");
        this.umax.reset("pi");
        this.vmin.reset("-pi/2");
        this.vmax.reset("pi/2");
        this.uPatchCount.setValueAndDefault(38);
        this.vPatchCount.setValueAndDefault(38);
        this.setDefaultOrientation(2);
        this.addParameter(this.aa);
    }

    private static double sin(double t) {
        return Math.sin(t);
    }

    private static double cos(double t) {
        return Math.cos(t);
    }

    @Override
    public Vector3D surfacePoint(double u, double v) {
        double AA = this.aa.getValue();
        double AASquare = AA * AA;
        return new Vector3D(AASquare * (CrossCap.sin(u) * CrossCap.sin(2.0 * v) / 2.0), AASquare * (CrossCap.sin(2.0 * u) * CrossCap.cos(v) * CrossCap.cos(v)), AASquare * (CrossCap.cos(2.0 * u) * CrossCap.cos(v) * CrossCap.cos(v)));
    }
}

