/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import vmm.core.RealParamAnimateable;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.SurfaceParametric;

public class Astroidale
extends SurfaceParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("vmm.surface.parametric.Astroidale.aa", "2.0", "2.0", "2.0");
    private RealParamAnimateable bb = new RealParamAnimateable("vmm.surface.parametric.Astroidale.bb", "3.0", "0.4", "3.0");

    public Astroidale() {
        this.uPatchCount.setValueAndDefault(16);
        this.vPatchCount.setValueAndDefault(10);
        this.umin.reset("-pi");
        this.umax.reset("pi");
        this.vmin.reset("-pi/2");
        this.vmax.reset("pi/2");
        this.setDefaultViewpoint(new Vector3D(10.0, -10.0, 10.0));
        this.setDefaultWindow(-2.5, 2.5, -2.5, 2.5);
        this.addParameter(this.aa);
        this.addParameter(this.bb);
    }

    private static double cospower(double t, double r) {
        return Math.signum(Math.cos(t)) * Math.exp(r * Math.log(Math.abs(Math.cos(t))));
    }

    private static double sinpower(double t, double r) {
        return Math.signum(Math.sin(t)) * Math.exp(r * Math.log(Math.abs(Math.sin(t))));
    }

    @Override
    public Vector3D surfacePoint(double u, double v) {
        double AA = this.aa.getValue();
        double BB = this.bb.getValue();
        double x = AA * Astroidale.cospower(u, BB) * Astroidale.cospower(v, BB);
        double y = AA * Astroidale.sinpower(u, BB) * Astroidale.cospower(v, BB);
        double z = AA * Astroidale.sinpower(v, BB);
        return new Vector3D(x, y, z);
    }
}

