/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.implicit;

import vmm.core3D.Vector3D;
import vmm.surface.implicit.SurfaceImplicit;

public class WhitneyUmbrella
extends SurfaceImplicit {
    public static double sqr(double x) {
        return x * x;
    }

    @Override
    public double heightFunction(double x, double y, double z) {
        double xsqr = WhitneyUmbrella.sqr(x);
        double zsqr = WhitneyUmbrella.sqr(z);
        double height = -(xsqr * y - zsqr);
        return height;
    }

    public WhitneyUmbrella() {
        this.setDefaultWindow(-3.2, 3.2, -3.2, 3.2);
        this.setDefaultViewpoint(new Vector3D(0.05, -17.33, 0.83));
        this.setDefaultViewUp(new Vector3D(1.0, 0.0, 0.0));
        this.searchRadius.reset(3.0);
        this.randomLineCount.reset(60000);
        this.pointCloudCount.reset(12000);
        this.level.reset(0.0, -0.5, 0.5);
        this.setFramesForMorphing(14);
        this.heightFunctionType = SurfaceImplicit.equationType.CUBIC;
    }
}

