/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface;

import java.awt.Graphics2D;
import vmm.core.Animation;
import vmm.core.IntegerParam;
import vmm.core.TimerAnimation;
import vmm.core.VMMSave;
import vmm.core.View;
import vmm.core3D.Exhibit3D;
import vmm.core3D.Grid3D;
import vmm.core3D.Transform3D;
import vmm.core3D.View3D;
import vmm.core3D.View3DLit;
import vmm.surface.SurfaceView;

public abstract class Surface
extends Exhibit3D {
    protected Grid3D data;
    protected IntegerParam uPatchCount = new IntegerParam("vmm.surface.Surface.uPatchCount", 18);
    protected IntegerParam vPatchCount = new IntegerParam("vmm.surface.Surface.vPatchCount", 18);
    @VMMSave
    private int defaultOrientation = 0;

    protected abstract void createData();

    public Surface() {
        this.addParameter(this.vPatchCount);
        this.addParameter(this.uPatchCount);
        this.vPatchCount.setMinimumValueForInput(1);
        this.uPatchCount.setMinimumValueForInput(1);
        this.vPatchCount.setMaximumValueForInput(40);
        this.uPatchCount.setMaximumValueForInput(40);
        this.setFramesForMorphing(12);
        this.setUseFilmstripForMorphing(true);
    }

    public int getDefaultOrientation() {
        return this.defaultOrientation;
    }

    public void setDefaultOrientation(int defaultOrientation) {
        if (defaultOrientation != this.defaultOrientation && (defaultOrientation == 0 || defaultOrientation == 2 || defaultOrientation == 1)) {
            this.defaultOrientation = defaultOrientation;
        }
    }

    @Override
    public View getDefaultView() {
        SurfaceView view = new SurfaceView();
        return view;
    }

    @Override
    public Animation getBuildAnimation(View view) {
        if (!(view instanceof View3DLit)) {
            return null;
        }
        if (((View3DLit)view).getRenderingStyle() == 0) {
            return null;
        }
        final View3DLit view3D = (View3DLit)view;
        return new TimerAnimation(0, 20){
            private double percentDrawn;
            private double batchSize;
            {
                super(frames, millisecondsPerFrame);
                this.batchSize = 0.02001;
            }

            @Override
            protected void drawFrame() {
                if (this.percentDrawn > 1.0) {
                    this.cancel();
                    return;
                }
                if (!view3D.beginDrawToOffscreenImage()) {
                    return;
                }
                if (view3D instanceof SurfaceView) {
                    SurfaceView v = (SurfaceView)view3D;
                    Surface.this.data.setUCurveIncrement(v.getShowUGridLines() ? v.getGridSpacing() : 0);
                    Surface.this.data.setVCurveIncrement(v.getShowVGridLines() ? v.getGridSpacing() : 0);
                }
                view3D.drawSurface(Surface.this.data, this.percentDrawn, this.percentDrawn + this.batchSize);
                view3D.endDrawToOffscreenImage();
                view3D.getDisplay().repaint();
                this.percentDrawn += this.batchSize;
            }
        };
    }

    @Override
    protected void computeDrawData3D(View3D view, boolean exhibitNeedsRedraw, Transform3D previousTransform, Transform3D newTransform) {
        if (exhibitNeedsRedraw) {
            this.createData();
        }
    }

    @Override
    protected void doDraw3D(Graphics2D g, View3D view, Transform3D transform) {
        if (view instanceof SurfaceView) {
            SurfaceView v = (SurfaceView)view;
            this.data.setUCurveIncrement(v.getShowUGridLines() ? v.getGridSpacing() : 0);
            this.data.setVCurveIncrement(v.getShowVGridLines() ? v.getGridSpacing() : 0);
        }
        if (view instanceof View3DLit) {
            ((View3DLit)view).drawSurface(this.data);
        } else {
            view.drawWireframeSurface(this.data);
        }
    }
}

