/*
 * Decompiled with CFR 0.152.
 */
package vmm.spacecurve.parametric;

import vmm.core.RealParamAnimateable;
import vmm.core3D.Vector3D;
import vmm.spacecurve.parametric.SphericalCurve;

public class Loxodrome
extends SphericalCurve {
    private RealParamAnimateable Slope;

    public Loxodrome() {
        this.tResolution.setValueAndDefault(300);
        this.tmin.setValueAndDefaultFromString("-8 * pi");
        this.tmax.setValueAndDefaultFromString("8 * pi");
        this.Slope = new RealParamAnimateable("vmm.spacecurve.parametric.Loxodrome.Slope", 0.2, 0.1, 0.3);
        this.addParameter(this.Slope);
        this.tubeSize.setValueAndDefault(0.1);
    }

    @Override
    protected Vector3D value(double t) {
        double r = Math.exp(this.Slope.getValue() * t);
        double x = 2.0 * r * Math.cos(t) / (1.0 + r * r);
        double y = 2.0 * r * Math.sin(t) / (1.0 + r * r);
        double z = (1.0 - r * r) / (1.0 + r * r);
        return new Vector3D(x, y, z);
    }
}

