/*
 * Decompiled with CFR 0.152.
 */
package vmm.spacecurve.parametric;

import vmm.core3D.Vector3D;
import vmm.spacecurve.parametric.SpaceCurveParametric;

public class Figure8Knot
extends SpaceCurveParametric {
    public Figure8Knot() {
        this.tmin.setValueAndDefault(0.0);
        this.tmax.setValueAndDefaultFromString("2 * pi");
        this.tResolution.setValueAndDefault(300);
        this.setDefaultViewpoint(new Vector3D(36.0, -138.0, 13.0));
        this.setDefaultWindow(-4.0, 4.0, -3.0, 3.0);
        this.tubeSize.setValueAndDefault(0.15);
    }

    @Override
    protected Vector3D value(double t) {
        return new Vector3D((32.0 * Math.cos(t) - 51.0 * Math.sin(t) - 104.0 * Math.cos(2.0 * t) - 34.0 * Math.sin(2.0 * t) + 104.0 * Math.cos(3.0 * t) - 91.0 * Math.sin(3.0 * t)) / 100.0, (94.0 * Math.cos(t) + 41.0 * Math.sin(t) + 113.0 * Math.cos(2.0 * t) - 68.0 * Math.cos(3.0 * t) - 124.0 * Math.sin(3.0 * t)) / 100.0, (16.0 * Math.sin(t) + 73.0 * Math.cos(t) - 211.0 * Math.cos(2.0 * t) - 39.0 * Math.sin(2.0 * t) - 99.0 * Math.cos(3.0 * t) - 21.0 * Math.sin(3.0 * t)) / 100.0);
    }

    @Override
    protected Vector3D deriv1(double t) {
        return new Vector3D((-32.0 * Math.sin(t) - 51.0 * Math.cos(t) + 104.0 * Math.sin(2.0 * t) * 2.0 - 34.0 * Math.cos(2.0 * t) * 2.0 - 104.0 * Math.sin(3.0 * t) * 3.0 - 91.0 * Math.cos(3.0 * t) * 3.0) / 100.0, (-94.0 * Math.sin(t) + 41.0 * Math.cos(t) - 113.0 * Math.sin(2.0 * t) * 2.0 + 68.0 * Math.sin(3.0 * t) * 3.0 - 124.0 * Math.cos(3.0 * t) * 3.0) / 100.0, (16.0 * Math.cos(t) - 73.0 * Math.sin(t) + 211.0 * Math.sin(2.0 * t) * 2.0 - 39.0 * Math.cos(2.0 * t) * 2.0 + 99.0 * Math.sin(3.0 * t) * 3.0 - 21.0 * Math.cos(3.0 * t) * 3.0) / 100.0);
    }

    @Override
    protected Vector3D deriv2(double t) {
        return new Vector3D((-32.0 * Math.cos(t) + 51.0 * Math.sin(t) + 104.0 * Math.cos(2.0 * t) * 4.0 + 34.0 * Math.sin(2.0 * t) * 4.0 - 104.0 * Math.cos(3.0 * t) * 9.0 + 91.0 * Math.sin(3.0 * t) * 9.0) / 100.0, (-94.0 * Math.cos(t) - 41.0 * Math.sin(t) - 113.0 * Math.cos(2.0 * t) * 4.0 + 68.0 * Math.cos(3.0 * t) * 9.0 + 124.0 * Math.sin(3.0 * t) * 9.0) / 100.0, (-16.0 * Math.sin(t) - 73.0 * Math.cos(t) + 211.0 * Math.cos(2.0 * t) * 4.0 + 39.0 * Math.sin(2.0 * t) * 4.0 + 99.0 * Math.cos(3.0 * t) * 9.0 + 21.0 * Math.sin(3.0 * t) * 9.0) / 100.0);
    }
}

