/*
 * Decompiled with CFR 0.152.
 */
package vmm.planecurve.parametric;

import vmm.core.RealParamAnimateable;
import vmm.planecurve.parametric.PlaneCurveParametric;

public class Logarithmicspiral
extends PlaneCurveParametric {
    private RealParamAnimateable aa;
    private RealParamAnimateable bb;

    public Logarithmicspiral() {
        this.tResolution.setValueAndDefault(500);
        this.aa = new RealParamAnimateable("aa", 1.0, 1.0, 1.0);
        this.bb = new RealParamAnimateable("bb", 0.08, 0.08, 0.04);
        this.addParameter(this.aa);
        this.addParameter(this.bb);
        this.tmin.setValueAndDefaultFromString("0");
        this.tmax.setValueAndDefaultFromString("12*pi");
        this.setDefaultWindow(-10.0, 10.0, -10.0, 10.0);
    }

    @Override
    public double xValue(double t) {
        double AA = this.aa.getValue();
        double BB = this.bb.getValue();
        return AA * Math.exp(BB * t) * Math.cos(t);
    }

    @Override
    public double yValue(double t) {
        double AA = this.aa.getValue();
        double BB = this.bb.getValue();
        return AA * Math.exp(BB * t) * Math.sin(t);
    }
}

