/*
 * Decompiled with CFR 0.152.
 */
package vmm.planecurve.parametric;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import vmm.actions.ActionList;
import vmm.actions.ToggleAction;
import vmm.core.Animation;
import vmm.core.Decoration;
import vmm.core.I18n;
import vmm.core.ThreadedAnimation;
import vmm.core.Transform;
import vmm.core.VMMSave;
import vmm.core.View;
import vmm.planecurve.parametric.PlaneCurveParametric;

public abstract class DecoratedCurve
extends PlaneCurveParametric {
    protected Color wantedColor;
    protected int strokeSize;

    public void setWantedColor(Color color) {
        this.wantedColor = color;
    }

    public Color getWantedColor() {
        Color color = this.wantedColor;
        return color;
    }

    public void setStrokeSize(int size) {
        this.strokeSize = size;
    }

    public int getStrokeSize() {
        int size = this.strokeSize;
        return size;
    }

    protected abstract void drawNeededStuff(Graphics2D var1, View var2, Transform var3, double var4);

    @Override
    public Animation getCreateAnimation(View view) {
        if (!(view instanceof MMOView)) {
            return null;
        }
        final MMOView myView = (MMOView)view;
        this.wantedColor = Color.green;
        this.strokeSize = 1;
        return new ThreadedAnimation(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runAnimation() {
                NeededStuffDecoration dec = null;
                try {
                    this.pause(100);
                    dec = new NeededStuffDecoration();
                    myView.addDecoration(dec);
                    this.pause(35);
                    int numPoints = DecoratedCurve.this.tResolution.getValue();
                    double t = DecoratedCurve.this.tmin.getValue();
                    double dt = (DecoratedCurve.this.tmax.getValue() - t) / (double)numPoints;
                    for (int reps = 0; reps < 2; ++reps) {
                        for (int i = 0; i < numPoints; ++i) {
                            myView.curveColor = DecoratedCurve.this.wantedColor;
                            dec.setT(t + (double)i * dt, i);
                            this.pause(35);
                        }
                    }
                }
                finally {
                    myView.fractionToDraw = 1.0;
                    myView.curveColor = null;
                    if (dec != null) {
                        myView.removeDecoration(dec);
                    }
                    myView.forceRedraw();
                }
            }
        };
    }

    @Override
    public void doDraw(Graphics2D g, View view, Transform transform) {
        if (this.points.length == 0) {
            return;
        }
        int pointCt = this.points.length;
        if (view instanceof PlaneCurveParametric.PlaneCurveParametricView) {
            double fraction = ((PlaneCurveParametric.PlaneCurveParametricView)view).fractionToDraw;
            if (fraction >= 0.0 && fraction < 1.0) {
                pointCt = (int)(fraction * (double)pointCt);
            }
            if (pointCt == 0) {
                pointCt = 1;
            }
        }
        Color saveColor = null;
        if (view instanceof MMOView && ((MMOView)view).curveColor != null) {
            saveColor = g.getColor();
            g.setColor(((MMOView)view).curveColor);
            view.setStrokeSizeMultiplier(this.strokeSize);
        }
        view.drawCurve(this.points, pointCt);
        if (saveColor != null) {
            g.setColor(saveColor);
        }
    }

    @Override
    public View getDefaultView() {
        MMOView view = new MMOView();
        view.setShowAxes(true);
        return view;
    }

    public static class MMOView
    extends PlaneCurveParametric.PlaneCurveParametricView {
        Color curveColor = null;
        protected boolean simplifyActionMenu = true;
        @VMMSave
        private boolean useCloud = false;
        protected ToggleAction useCloudToggle = new ToggleAction(I18n.tr("vmm.planecurve.parametric.PlaneCurveParameteric.ToggleUseCloud"), false){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MMOView.this.setUseCloud(!MMOView.this.useCloud);
            }
        };

        public boolean getUseCloud() {
            return this.useCloud;
        }

        public void setUseCloud(boolean useCloud) {
            if (useCloud == this.useCloud) {
                return;
            }
            this.useCloudToggle.setState(useCloud);
            this.forceRedraw();
            this.useCloud = useCloud;
        }

        @Override
        public ActionList getActions() {
            ActionList actions = super.getActions();
            if (!this.simplifyActionMenu) {
                actions.add(this.useCloudToggle);
            }
            return actions;
        }
    }

    private class NeededStuffDecoration
    extends Decoration {
        double t = Double.NaN;
        int i = 0;

        private NeededStuffDecoration() {
        }

        void setT(double t, int i) {
            this.t = t;
            this.i = i;
            this.fireDecorationChangeEvent();
        }

        @Override
        public void doDraw(Graphics2D g, View view, Transform limits) {
            DecoratedCurve.this.drawNeededStuff(g, view, limits, this.t);
            MMOView myView = (MMOView)view;
            myView.drawCurve(DecoratedCurve.this.points, this.i, DecoratedCurve.this.points.length - 1);
        }
    }
}

