/*
 * Decompiled with CFR 0.152.
 */
package vmm.planecurve.parametric;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import vmm.core.I18n;
import vmm.core.RealParamAnimateable;
import vmm.core.Transform;
import vmm.core.View;
import vmm.planecurve.parametric.DecoratedCurve;

public class Circle
extends DecoratedCurve {
    private RealParamAnimateable radius = new RealParamAnimateable("vmm.planecurve.parametric.Circle.Radius", 3.0, 1.0, 5.0);
    private int pointCount;

    public Circle() {
        this.radius.setMinimumValueForInput(Double.MIN_VALUE);
        this.tmin.setValueAndDefault(0.0);
        this.tmax.setValueAndDefaultFromString("2 * pi");
        this.tResolution.setValueAndDefaultFromString("400");
        this.addParameter(this.radius);
        this.pointCount = 6600;
        this.randomSquare = this.fillRandomSquare(this.pointCount);
        this.movingSquare = this.initializeMovingSquare(this.pointCount);
    }

    @Override
    public double xValue(double t) {
        return this.radius.getValue() * Math.cos(t);
    }

    @Override
    public double yValue(double t) {
        return this.radius.getValue() * Math.sin(t);
    }

    @Override
    public double xDerivativeValue(double t) {
        return -this.radius.getValue() * Math.sin(t);
    }

    @Override
    public double yDerivativeValue(double t) {
        return this.radius.getValue() * Math.cos(t);
    }

    @Override
    public double x2ndDerivativeValue(double t) {
        return -this.radius.getValue() * Math.cos(t);
    }

    @Override
    public double y2ndDerivativeValue(double t) {
        return -this.radius.getValue() * Math.sin(t);
    }

    @Override
    public View getDefaultView() {
        class CircleView
        extends DecoratedCurve.MMOView {
            CircleView() {
                this.setShowAxes(true);
                this.simplifyActionMenu = false;
                this.setUseCloud(false);
                this.useCloudToggle.putValue("Name", I18n.tr("vmm.planecurve.parametric.PlaneCurveParameteric.ToggleUseCloudForCircle"));
            }
        }
        return new CircleView();
    }

    @Override
    protected void drawNeededStuff(Graphics2D g, View view, Transform limits, double t) {
        DecoratedCurve.MMOView myView = (DecoratedCurve.MMOView)view;
        Color saveColor = g.getColor();
        this.setWantedColor(saveColor);
        double xa = this.xValue(t);
        double ya = this.yValue(t);
        double r = this.radius.getValue();
        myView.setStrokeSizeMultiplier(2);
        g.setColor(Color.blue);
        g.draw(new Line2D.Double(-r, 0.0, r, 0.0));
        g.draw(new Line2D.Double(0.0, 0.0, 0.0, -r * Math.signum(ya)));
        g.setColor(Color.red);
        g.draw(new Line2D.Double(-r, 0.0, xa, ya));
        g.draw(new Line2D.Double(xa, ya, r, 0.0));
        myView.setStrokeSizeMultiplier(1);
        g.draw(new Line2D.Double(xa, ya, 0.0, -r * Math.signum(ya)));
        if (myView.getUseCloud()) {
            g.setColor(Color.blue);
            g.draw(new Line2D.Double(xa, ya, -xa / 5.0, -ya / 5.0));
        }
        g.setColor(saveColor);
    }
}

